/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.client.render.model.curio.feet.BunnyHoppersModel;
import artifacts.common.config.ModConfig;
import artifacts.common.item.HurtSoundModifyingItem;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.EventPriority;

public class BunnyHoppersItem
extends HurtSoundModifyingItem {
    private static final ResourceLocation TEXTURE = new ResourceLocation("artifacts", "textures/entity/curio/bunny_hoppers.png");

    public BunnyHoppersItem() {
        super(SoundEvents.field_187822_em);
        this.addListener(EventPriority.HIGH, LivingFallEvent.class, this::onLivingFall);
        this.addListener(LivingEvent.LivingJumpEvent.class, this::onLivingJump);
    }

    private void onLivingFall(LivingFallEvent event, LivingEntity wearer) {
        if (((Boolean)ModConfig.server.bunnyHoppers.shouldCancelFallDamage.get()).booleanValue()) {
            event.setDamageMultiplier(0.0f);
        }
    }

    private void onLivingJump(LivingEvent.LivingJumpEvent event, LivingEntity wearer) {
        this.damageEquippedStacks(wearer);
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        int jumpBoostLevel = (Integer)ModConfig.server.bunnyHoppers.jumpBoostLevel.get() - 1;
        if (!ModConfig.server.isCosmetic(this) && !livingEntity.field_70170_p.field_72995_K && livingEntity.field_70173_aa % 15 == 0 && jumpBoostLevel >= 0) {
            livingEntity.func_195064_c(new EffectInstance(Effects.field_76430_j, 39, jumpBoostLevel, true, false));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected BipedModel<LivingEntity> createModel() {
        return new BunnyHoppersModel();
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }
}

