/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.client.render.model.curio.belt.CloudInABottleModel;
import artifacts.common.config.ModConfig;
import artifacts.common.init.ModItems;
import artifacts.common.init.ModSoundEvents;
import artifacts.common.item.CurioItem;
import artifacts.common.network.DoubleJumpPacket;
import artifacts.common.network.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CloudInABottleItem
extends CurioItem {
    private static final ResourceLocation TEXTURE = new ResourceLocation("artifacts", "textures/entity/curio/cloud_in_a_bottle.png");

    public CloudInABottleItem() {
        MinecraftForge.EVENT_BUS.register((Object)new DoubleJumpHandler());
        this.addListener(EventPriority.HIGHEST, LivingFallEvent.class, this::onLivingFall);
    }

    public void jump(PlayerEntity player) {
        player.field_70143_R = 0.0f;
        double upwardsMotion = 0.5;
        if (player.func_70644_a(Effects.field_76430_j)) {
            upwardsMotion += 0.1 * (double)(player.func_70660_b(Effects.field_76430_j).func_76458_c() + 1);
        }
        Vector3d motion = player.func_213322_ci();
        double motionMultiplier = player.func_70051_ag() ? (Double)ModConfig.server.cloudInABottle.sprintJumpDistanceMultiplier.get() : 0.0;
        float direction = (float)((double)player.field_70177_z * Math.PI / 180.0);
        player.func_213317_d(player.func_213322_ci().func_72441_c((double)(-MathHelper.func_76126_a((float)direction)) * motionMultiplier, (upwardsMotion *= player.func_70051_ag() ? (Double)ModConfig.server.cloudInABottle.sprintJumpHeightMultiplier.get() : 1.0) - motion.field_72448_b, (double)MathHelper.func_76134_b((float)direction) * motionMultiplier));
        player.field_70160_al = true;
        ForgeHooks.onLivingJump((LivingEntity)player);
        player.func_195066_a(Stats.field_75953_u);
        if (player.func_70051_ag()) {
            player.func_71020_j(0.2f);
        } else {
            player.func_71020_j(0.05f);
        }
        if (CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.WHOOPEE_CUSHION.get(), (LivingEntity)player).isPresent()) {
            player.func_184185_a((SoundEvent)ModSoundEvents.FART.get(), 1.0f, 0.9f + player.func_70681_au().nextFloat() * 0.2f);
        } else {
            player.func_184185_a(SoundEvents.field_187548_af, 1.0f, 0.9f + player.func_70681_au().nextFloat() * 0.2f);
        }
        this.damageEquippedStacks((LivingEntity)player);
    }

    private void onLivingFall(LivingFallEvent event, LivingEntity wearer) {
        event.setDistance(Math.max(0.0f, event.getDistance() - 3.0f));
    }

    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.field_187618_I, 1.0f, 1.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected BipedModel<LivingEntity> createModel() {
        return new CloudInABottleModel();
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    private class DoubleJumpHandler {
        @OnlyIn(value=Dist.CLIENT)
        private boolean canDoubleJump;
        @OnlyIn(value=Dist.CLIENT)
        private boolean hasReleasedJumpKey;

        private DoubleJumpHandler() {
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void onClientTick(TickEvent.ClientTickEvent event) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (event.phase == TickEvent.Phase.END && player != null && player.field_71158_b != null) {
                if ((player.func_233570_aj_() || player.func_70617_f_()) && !player.func_70090_H()) {
                    this.hasReleasedJumpKey = false;
                    this.canDoubleJump = true;
                } else if (!player.field_71158_b.field_78901_c) {
                    this.hasReleasedJumpKey = true;
                } else if (!player.field_71075_bZ.field_75100_b && this.canDoubleJump && this.hasReleasedJumpKey) {
                    this.canDoubleJump = false;
                    if (CloudInABottleItem.this.isEquippedBy((LivingEntity)player)) {
                        NetworkHandler.INSTANCE.sendToServer((Object)new DoubleJumpPacket());
                        CloudInABottleItem.this.jump((PlayerEntity)player);
                    }
                }
            }
        }
    }
}

