/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.client.render.model.curio.belt.CrystalHeartModel;
import artifacts.common.config.ModConfig;
import artifacts.common.item.CurioItem;
import java.util.UUID;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CrystalHeartItem
extends CurioItem {
    private static final ResourceLocation TEXTURE = new ResourceLocation("artifacts", "textures/entity/curio/crystal_heart.png");

    public CrystalHeartItem() {
        this.addListener(LivingDamageEvent.class, this::onLivingDamage);
    }

    private static AttributeModifier getHealthBonus() {
        int healthBonus = (Integer)ModConfig.server.crystalHeart.healthBonus.get();
        return new AttributeModifier(UUID.fromString("99fa0537-90b9-481a-bc76-4650987faba3"), "artifacts:crystal_heart_health_bonus", (double)healthBonus, AttributeModifier.Operation.ADDITION);
    }

    private void onLivingDamage(LivingDamageEvent event, LivingEntity wearer) {
        if (!event.isCanceled() && event.getAmount() >= 1.0f) {
            this.damageEquippedStacks(wearer, (int)event.getAmount());
        }
    }

    public void onEquip(SlotContext slotContext, ItemStack originalStack, ItemStack newStack) {
        if (!ModConfig.server.isCosmetic(this) && !slotContext.getWearer().field_70170_p.func_201670_d()) {
            ModifiableAttributeInstance health = slotContext.getWearer().func_110148_a(Attributes.field_233818_a_);
            AttributeModifier healthBonus = CrystalHeartItem.getHealthBonus();
            if (health != null && !health.func_180374_a(healthBonus)) {
                health.func_233769_c_(healthBonus);
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack originalStack, ItemStack newStack) {
        if (!ModConfig.server.isCosmetic(this) && !slotContext.getWearer().field_70170_p.func_201670_d()) {
            ModifiableAttributeInstance health = slotContext.getWearer().func_110148_a(Attributes.field_233818_a_);
            AttributeModifier healthBonus = CrystalHeartItem.getHealthBonus();
            if (health != null && health.func_180374_a(healthBonus)) {
                health.func_111124_b(healthBonus);
                if (slotContext.getWearer().func_110143_aJ() > slotContext.getWearer().func_110138_aP()) {
                    slotContext.getWearer().func_70606_j(slotContext.getWearer().func_110138_aP());
                }
            }
        }
    }

    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.field_187716_o, 1.0f, 1.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected BipedModel<LivingEntity> createModel() {
        return new CrystalHeartModel();
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }
}

