/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.common.config.ModConfig;
import artifacts.common.item.ArtifactItem;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public abstract class CurioItem
extends ArtifactItem
implements ICurioItem {
    private Object model;

    public boolean isEquippedBy(@Nullable LivingEntity entity) {
        return !ModConfig.server.isCosmetic(this) && entity != null && CuriosApi.getCuriosHelper().findEquippedCurio((Item)this, entity).isPresent();
    }

    protected <T extends Event, S extends LivingEntity> void addListener(EventPriority priority, Class<T> eventClass, BiConsumer<T, S> listener, Function<T, S> wearerSupplier) {
        MinecraftForge.EVENT_BUS.addListener(priority, true, eventClass, event -> {
            LivingEntity wearer = (LivingEntity)wearerSupplier.apply(event);
            if (this.isEquippedBy(wearer)) {
                listener.accept(event, wearer);
            }
        });
    }

    protected <T extends Event, S extends LivingEntity> void addListener(Class<T> eventClass, BiConsumer<T, S> listener, Function<T, S> wearerSupplier) {
        this.addListener(EventPriority.NORMAL, eventClass, listener, wearerSupplier);
    }

    protected <T extends LivingEvent> void addListener(EventPriority priority, Class<T> eventClass, BiConsumer<T, LivingEntity> listener) {
        this.addListener(priority, eventClass, listener, LivingEvent::getEntityLiving);
    }

    protected <T extends LivingEvent> void addListener(Class<T> eventClass, BiConsumer<T, LivingEntity> listener) {
        this.addListener(EventPriority.NORMAL, eventClass, listener);
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.RARE;
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean canRender(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        return true;
    }

    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack stack) {
        BipedModel<LivingEntity> model = this.getModel();
        model.func_225597_a_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.func_212843_a_(entity, limbSwing, limbSwingAmount, partialTicks);
        ICurio.RenderHelper.followBodyRotations((LivingEntity)entity, (BipedModel[])new BipedModel[]{model});
        IVertexBuilder vertexBuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)model.func_228282_a_(this.getTexture()), (boolean)false, (boolean)stack.func_77962_s());
        model.func_225598_a_(matrixStack, vertexBuilder, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void damageStack(String identifier, int index, LivingEntity entity, ItemStack stack) {
        this.damageStack(identifier, index, entity, stack, 1);
    }

    protected void damageStack(String identifier, int index, LivingEntity entity, ItemStack stack, int damage) {
        stack.func_222118_a(damage, entity, damager -> CuriosApi.getCuriosHelper().onBrokenCurio(identifier, index, damager));
    }

    protected void damageEquippedStacks(LivingEntity entity, int damage) {
        CuriosApi.getCuriosHelper().getCuriosHandler(entity).ifPresent(curiosHandler -> curiosHandler.getCurios().forEach((identifier, stacksHandler) -> {
            IDynamicStackHandler stacks = stacksHandler.getStacks();
            for (int slot = 0; slot < stacks.getSlots(); ++slot) {
                ItemStack stack = stacks.getStackInSlot(slot);
                if (stack.func_190926_b() || stack.func_77973_b() != this) continue;
                this.damageStack((String)identifier, slot, entity, stack, damage);
            }
        }));
    }

    public void damageEquippedStacks(LivingEntity entity) {
        this.damageEquippedStacks(entity, 1);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected final BipedModel<LivingEntity> getModel() {
        if (this.model == null) {
            this.model = this.createModel();
        }
        return (BipedModel)this.model;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract BipedModel<LivingEntity> createModel();

    protected abstract ResourceLocation getTexture();
}

