/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.client.render.model.curio.head.DrinkingHatModel;
import artifacts.common.config.ModConfig;
import artifacts.common.init.ModItems;
import artifacts.common.item.CurioItem;
import java.util.List;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class DrinkingHatItem
extends CurioItem {
    private final ResourceLocation texture;

    public DrinkingHatItem(ResourceLocation texture) {
        this.texture = texture;
        this.addListener(LivingEntityUseItemEvent.Start.class, this::onItemUseStart);
        this.addListener(LivingEntityUseItemEvent.Finish.class, this::onItemUseFinish);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        if (((Boolean)ModConfig.client.showTooltips.get()).booleanValue() && ModConfig.server != null && !ModConfig.server.isCosmetic(this) && this != ModItems.PLASTIC_DRINKING_HAT.get()) {
            tooltip.add((ITextComponent)new TranslationTextComponent(((CurioItem)ModItems.PLASTIC_DRINKING_HAT.get()).func_77658_a() + ".tooltip").func_240699_a_(TextFormatting.GRAY));
        }
        super.func_77624_a(stack, world, tooltip, flags);
    }

    private void onItemUseStart(LivingEntityUseItemEvent.Start event, LivingEntity wearer) {
        if (this.canApplyEffect((LivingEntityUseItemEvent)event)) {
            double drinkingDurationMultiplier = (Double)ModConfig.server.drinkingHats.get((Object)((Object)this)).drinkingDurationMultiplier.get();
            event.setDuration((int)((double)event.getDuration() * drinkingDurationMultiplier));
        }
    }

    private void onItemUseFinish(LivingEntityUseItemEvent.Finish event, LivingEntity wearer) {
        if (this.canApplyEffect((LivingEntityUseItemEvent)event)) {
            this.damageEquippedStacks(wearer);
        }
    }

    private boolean canApplyEffect(LivingEntityUseItemEvent event) {
        UseAction action = event.getItem().func_77975_n();
        return action == UseAction.DRINK || action == UseAction.EAT && (Boolean)ModConfig.server.drinkingHats.get((Object)((Object)this)).enableFastEating.get() != false;
    }

    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.field_187615_H, 1.0f, 1.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected BipedModel<LivingEntity> createModel() {
        return new DrinkingHatModel();
    }

    @Override
    protected ResourceLocation getTexture() {
        return this.texture;
    }
}

