/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.client.RenderTypes;
import artifacts.client.render.model.curio.hands.HandsModel;
import artifacts.common.config.ModConfig;
import artifacts.common.item.GloveItem;
import artifacts.common.util.DamageSourceHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class FireGauntletItem
extends GloveItem {
    private static final ResourceLocation TEXTURE_DEFAULT = new ResourceLocation("artifacts", "textures/entity/curio/fire_gauntlet_default.png");
    private static final ResourceLocation TEXTURE_SLIM = new ResourceLocation("artifacts", "textures/entity/curio/fire_gauntlet_slim.png");
    private static final ResourceLocation TEXTURE_DEFAULT_GLOW = new ResourceLocation("artifacts", "textures/entity/curio/fire_gauntlet_default_glow.png");
    private static final ResourceLocation TEXTURE_SLIM_GLOW = new ResourceLocation("artifacts", "textures/entity/curio/fire_gauntlet_slim_glow.png");

    public FireGauntletItem() {
        this.addListener(LivingAttackEvent.class, this::onLivingAttack, (T event) -> DamageSourceHelper.getAttacker(event.getSource()));
    }

    private void onLivingAttack(LivingAttackEvent event, LivingEntity wearer) {
        if (DamageSourceHelper.isMeleeAttack(event.getSource()) && !event.getEntity().func_230279_az_()) {
            event.getEntity().func_70015_d(((Integer)ModConfig.server.fireGauntlet.fireDuration.get()).intValue());
            this.damageEquippedStacks(wearer);
        }
    }

    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.field_187725_r, 1.0f, 1.0f);
    }

    @Override
    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack stack) {
        super.render(identifier, index, matrixStack, buffer, light, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, stack);
        boolean smallArms = FireGauntletItem.hasSmallArms((Entity)entity);
        HandsModel model = this.getModel(smallArms);
        IVertexBuilder builder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)buffer, (RenderType)RenderTypes.unlit(this.getGlowTexture(smallArms)), (boolean)false, (boolean)false);
        model.renderHand(index % 2 == 0, matrixStack, builder, 0xF000F0, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderArm(MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, AbstractClientPlayerEntity player, HandSide side, boolean hasFoil) {
        if (!player.func_175149_v()) {
            super.renderArm(matrixStack, buffer, combinedLight, player, side, hasFoil);
            boolean smallArms = FireGauntletItem.hasSmallArms((Entity)player);
            HandsModel model = this.getModel(smallArms);
            ModelRenderer arm = side == HandSide.LEFT ? model.field_178724_i : model.field_178723_h;
            IVertexBuilder builder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)buffer, (RenderType)RenderTypes.unlit(this.getGlowTexture(smallArms)), (boolean)false, (boolean)false);
            arm.func_228308_a_(matrixStack, builder, 0xF000F0, OverlayTexture.field_229196_a_);
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE_DEFAULT;
    }

    @Override
    protected ResourceLocation getSlimTexture() {
        return TEXTURE_SLIM;
    }

    protected ResourceLocation getGlowTexture(boolean smallArms) {
        return smallArms ? TEXTURE_SLIM_GLOW : TEXTURE_DEFAULT_GLOW;
    }
}

