/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.client.render.model.curio.feet.FlippersModel;
import artifacts.common.config.ModConfig;
import artifacts.common.item.CurioItem;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import top.theillusivec4.curios.api.SlotContext;

public class FlippersItem
extends CurioItem {
    private static final ResourceLocation TEXTURE = new ResourceLocation("artifacts", "textures/entity/curio/flippers.png");

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (livingEntity.field_70173_aa % 20 == 0 && livingEntity.func_203007_ba()) {
            this.damageStack(identifier, index, livingEntity, stack);
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Multimap result = super.getAttributeModifiers(slotContext, uuid, stack);
        if (!ModConfig.server.isCosmetic(this)) {
            double swimSpeedBonus = (Double)ModConfig.server.flippers.swimSpeedBonus.get();
            result.put((Object)ForgeMod.SWIM_SPEED.get(), (Object)new AttributeModifier(uuid, new ResourceLocation("artifacts", "flipper_swim_speed").toString(), swimSpeedBonus, AttributeModifier.Operation.ADDITION));
        }
        return result;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected BipedModel<LivingEntity> createModel() {
        return new FlippersModel();
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }
}

