/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.client.render.model.curio.hands.GloveModel;
import artifacts.client.render.model.curio.hands.HandsModel;
import artifacts.common.item.CurioItem;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.type.capability.ICurio;

public abstract class GloveItem
extends CurioItem {
    private Object modelSlim;

    protected static boolean hasSmallArms(Entity entity) {
        return entity instanceof AbstractClientPlayerEntity && ((AbstractClientPlayerEntity)entity).func_175154_l().equals("slim");
    }

    protected ResourceLocation getTexture(boolean smallArms) {
        return smallArms ? this.getSlimTexture() : this.getTexture();
    }

    protected abstract ResourceLocation getSlimTexture();

    @OnlyIn(value=Dist.CLIENT)
    protected HandsModel getModel(boolean smallArms) {
        return smallArms ? this.getSlimModel() : (HandsModel)this.getModel();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected final HandsModel getSlimModel() {
        if (this.modelSlim == null) {
            this.modelSlim = this.createModel(true);
        }
        return (HandsModel)((Object)this.modelSlim);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected final HandsModel createModel() {
        return this.createModel(false);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected HandsModel createModel(boolean smallArms) {
        return new GloveModel(smallArms);
    }

    @Override
    public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack stack) {
        boolean smallArms = GloveItem.hasSmallArms((Entity)entity);
        HandsModel model = this.getModel(smallArms);
        model.func_225597_a_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.func_212843_a_(entity, limbSwing, limbSwingAmount, partialTicks);
        ICurio.RenderHelper.followBodyRotations((LivingEntity)entity, (BipedModel[])new BipedModel[]{model});
        IVertexBuilder vertexBuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)buffer, (RenderType)model.func_228282_a_(this.getTexture(smallArms)), (boolean)false, (boolean)stack.func_77962_s());
        model.renderHand(index % 2 == 0, matrixStack, vertexBuilder, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderArm(MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, AbstractClientPlayerEntity player, HandSide side, boolean hasFoil) {
        if (!player.func_175149_v()) {
            boolean smallArms = GloveItem.hasSmallArms((Entity)player);
            HandsModel model = this.getModel(smallArms);
            ModelRenderer arm = side == HandSide.LEFT ? model.field_178724_i : model.field_178723_h;
            model.func_178719_a(false);
            arm.field_78806_j = true;
            model.field_228270_o_ = false;
            model.field_205061_a = 0.0f;
            model.field_217112_c = 0.0f;
            model.func_225597_a_((LivingEntity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            arm.field_78795_f = 0.0f;
            arm.func_228308_a_(matrixStack, ItemRenderer.func_229113_a_((IRenderTypeBuffer)buffer, (RenderType)model.func_228282_a_(this.getTexture(smallArms)), (boolean)false, (boolean)hasFoil), combinedLight, OverlayTexture.field_229196_a_);
        }
    }
}

