/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.client.render.model.curio.hands.GloveModel;
import artifacts.client.render.model.curio.hands.GoldenHookModel;
import artifacts.common.capability.killtracker.EntityKillTrackerCapability;
import artifacts.common.config.ModConfig;
import artifacts.common.item.GloveItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;

public class GoldenHookItem
extends GloveItem {
    private static final ResourceLocation TEXTURE_DEFAULT = new ResourceLocation("artifacts", "textures/entity/curio/golden_hook_default.png");
    private static final ResourceLocation TEXTURE_SLIM = new ResourceLocation("artifacts", "textures/entity/curio/golden_hook_slim.png");

    public GoldenHookItem() {
        this.addListener(LivingExperienceDropEvent.class, this::onLivingExperienceDrop, LivingExperienceDropEvent::getAttackingPlayer);
    }

    private void onLivingExperienceDrop(LivingExperienceDropEvent event, LivingEntity wearer) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            return;
        }
        double killRatio = wearer.getCapability(EntityKillTrackerCapability.INSTANCE).map(tracker -> tracker.getKillRatio(event.getEntityLiving().func_200600_R())).orElse(0.0);
        double minMultiplier = (Double)ModConfig.server.goldenHook.minExperienceMultiplier.get();
        double maxMultiplier = (Double)ModConfig.server.goldenHook.maxExperienceMultiplier.get();
        double maxKillRatio = (Double)ModConfig.server.goldenHook.maximumKillRatio.get();
        double maxExperience = ((Integer)ModConfig.server.goldenHook.maxExperience.get()).intValue();
        double multiplier = MathHelper.func_219803_d((double)Math.max(0.0, (maxKillRatio - killRatio) / maxKillRatio), (double)minMultiplier, (double)maxMultiplier);
        int experienceBonus = (int)Math.min(maxExperience, multiplier * (double)event.getOriginalExperience());
        event.setDroppedExperience(event.getDroppedExperience() + experienceBonus);
        this.damageEquippedStacks(wearer);
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE_DEFAULT;
    }

    @Override
    protected ResourceLocation getSlimTexture() {
        return TEXTURE_SLIM;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected GloveModel createModel(boolean smallArms) {
        return new GoldenHookModel(smallArms);
    }
}

