/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.client.render.model.curio.belt.HeliumFlamingoModel;
import artifacts.common.capability.swimhandler.SwimHandlerCapability;
import artifacts.common.config.ModConfig;
import artifacts.common.init.ModSoundEvents;
import artifacts.common.item.CurioItem;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class HeliumFlamingoItem
extends CurioItem {
    private static final ResourceLocation TEXTURE = new ResourceLocation("artifacts", "textures/entity/curio/helium_flamingo.png");

    public HeliumFlamingoItem() {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerTick);
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo((SoundEvent)ModSoundEvents.POP.get(), 1.0f, 0.7f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        if (ModConfig.server != null && ModConfig.server.isCosmetic(this)) {
            super.func_77624_a(stack, world, tooltip, flags);
        } else if (((Boolean)ModConfig.client.showTooltips.get()).booleanValue()) {
            tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".tooltip.0").func_240699_a_(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".tooltip.1", new Object[]{Minecraft.func_71410_x().field_71474_y.field_151444_V.func_238171_j_()}).func_240699_a_(TextFormatting.GRAY));
        }
    }

    private void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        event.player.getCapability(SwimHandlerCapability.INSTANCE).ifPresent(handler -> {
            if (handler.isSwimming()) {
                if (!this.isEquippedBy((LivingEntity)event.player) || event.player.func_70086_ai() <= 0 || event.player.func_70090_H() && !event.player.func_203007_ba() && !handler.isSinking() || (!event.player.func_70090_H() || handler.isSinking()) && event.player.func_233570_aj_()) {
                    handler.setSwimming(false);
                    if (!event.player.func_233570_aj_() && !event.player.func_70090_H()) {
                        event.player.func_184185_a((SoundEvent)ModSoundEvents.POP.get(), 0.5f, 0.75f);
                    }
                }
                if (this.isEquippedBy((LivingEntity)event.player) && !event.player.func_208600_a((ITag)FluidTags.field_206959_a)) {
                    if (event.player.field_70173_aa % 20 == 0) {
                        this.damageEquippedStacks((LivingEntity)event.player);
                    }
                    if (!event.player.field_71075_bZ.field_75102_a && (Integer)ModConfig.server.heliumFlamingo.airSupplyDrainRate.get() > 0) {
                        int airSupply = event.player.func_70086_ai() - 4;
                        event.player.func_70050_g(airSupply - (Integer)ModConfig.server.heliumFlamingo.airSupplyDrainRate.get());
                    }
                }
            }
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected BipedModel<LivingEntity> createModel() {
        return new HeliumFlamingoModel();
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    private class ClientEventHandler {
        private final ResourceLocation location = new ResourceLocation("artifacts", "textures/gui/icons.png");
        private boolean wasSprintKeyDown;
        private boolean wasSprintingOnGround;
        private boolean hasTouchedGround;

        private ClientEventHandler() {
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public void onInputUpdate(InputUpdateEvent event) {
            if (ModConfig.server.isCosmetic(HeliumFlamingoItem.this)) {
                return;
            }
            PlayerEntity player = event.getPlayer();
            boolean isSprintKeyDown = Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151470_d();
            player.getCapability(SwimHandlerCapability.INSTANCE).ifPresent(handler -> {
                if (!handler.isSwimming()) {
                    if (player.func_233570_aj_()) {
                        this.hasTouchedGround = true;
                    } else if (!(handler.isSwimming() || player.func_70086_ai() <= 0 || !HeliumFlamingoItem.this.isEquippedBy((LivingEntity)player) || !player.func_203007_ba() && (!isSprintKeyDown || this.wasSprintKeyDown || this.wasSprintingOnGround || !this.hasTouchedGround || player.func_233570_aj_() || player.func_70090_H() && !handler.isSinking() || player.func_184613_cA() || player.field_71075_bZ.field_75100_b || player.func_184218_aH()))) {
                        handler.setSwimming(true);
                        handler.syncSwimming();
                        this.hasTouchedGround = false;
                    }
                } else if (player.field_71075_bZ.field_75100_b) {
                    handler.setSwimming(false);
                    handler.syncSwimming();
                    this.hasTouchedGround = true;
                }
            });
            this.wasSprintKeyDown = isSprintKeyDown;
            if (!isSprintKeyDown) {
                this.wasSprintingOnGround = false;
            } else if (player.func_233570_aj_()) {
                this.wasSprintingOnGround = true;
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent(priority=EventPriority.LOW)
        public void render(RenderGameOverlayEvent.Pre event) {
            Minecraft minecraft = Minecraft.func_71410_x();
            if (ModConfig.server.isCosmetic(HeliumFlamingoItem.this) || !(minecraft.func_175606_aa() instanceof LivingEntity)) {
                return;
            }
            LivingEntity player = (LivingEntity)minecraft.func_175606_aa();
            if (event.getType() == RenderGameOverlayEvent.ElementType.AIR && !event.isCanceled() && HeliumFlamingoItem.this.isEquippedBy(player)) {
                event.setCanceled(true);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.location);
                RenderSystem.enableBlend();
                int left = minecraft.func_228018_at_().func_198107_o() / 2 + 91;
                int top = minecraft.func_228018_at_().func_198087_p() - ForgeIngameGui.right_height;
                int air = player.func_70086_ai();
                if (player.func_208600_a((ITag)FluidTags.field_206959_a) || air < 300) {
                    int full = MathHelper.func_76143_f((double)((double)((air - 2) * 10) / 300.0));
                    int partial = MathHelper.func_76143_f((double)((double)(air * 10) / 300.0)) - full;
                    for (int i = 0; i < full + partial; ++i) {
                        ForgeIngameGui.func_238464_a_((MatrixStack)event.getMatrixStack(), (int)(left - i * 8 - 9), (int)top, (int)-90, (float)(i < full ? 0 : 9), (float)0.0f, (int)9, (int)9, (int)16, (int)32);
                    }
                    ForgeIngameGui.right_height += 10;
                }
                RenderSystem.disableBlend();
            }
        }
    }
}

