/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.common.config.ModConfig;
import artifacts.common.item.GloveItem;
import artifacts.common.util.DamageSourceHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class PocketPistonItem
extends GloveItem {
    private static final ResourceLocation TEXTURE_DEFAULT = new ResourceLocation("artifacts", "textures/entity/curio/pocket_piston_default.png");
    private static final ResourceLocation TEXTURE_SLIM = new ResourceLocation("artifacts", "textures/entity/curio/pocket_piston_slim.png");

    public PocketPistonItem() {
        this.addListener(LivingAttackEvent.class, this::onLivingAttack, (T event) -> DamageSourceHelper.getAttacker(event.getSource()));
    }

    private void onLivingAttack(LivingAttackEvent event, LivingEntity wearer) {
        float knockbackBonus = (float)((Double)ModConfig.server.pocketPiston.knockbackBonus.get()).doubleValue();
        event.getEntityLiving().func_233627_a_(knockbackBonus, (double)MathHelper.func_76126_a((float)((float)((double)wearer.field_70177_z * (Math.PI / 180)))), (double)(-MathHelper.func_76134_b((float)((float)((double)wearer.field_70177_z * (Math.PI / 180))))));
        this.damageEquippedStacks(wearer);
    }

    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.field_187715_dR, 1.0f, 1.0f);
    }

    @Override
    protected ResourceLocation getSlimTexture() {
        return TEXTURE_SLIM;
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE_DEFAULT;
    }
}

