/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.common.config.ModConfig;
import artifacts.common.item.GloveItem;
import artifacts.common.util.DamageSourceHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.EventPriority;

public class VampiricGloveItem
extends GloveItem {
    private static final ResourceLocation TEXTURE_DEFAULT = new ResourceLocation("artifacts", "textures/entity/curio/vampiric_glove_default.png");
    private static final ResourceLocation TEXTURE_SLIM = new ResourceLocation("artifacts", "textures/entity/curio/vampiric_glove_slim.png");

    public VampiricGloveItem() {
        this.addListener(EventPriority.LOWEST, LivingDamageEvent.class, this::onLivingDamage, event -> DamageSourceHelper.getAttacker(event.getSource()));
    }

    private void onLivingDamage(LivingDamageEvent event, LivingEntity wearer) {
        if (DamageSourceHelper.isMeleeAttack(event.getSource())) {
            float damageDealt;
            float absorptionRatio;
            int maxHealthAbsorbed = (Integer)ModConfig.server.vampiricGlove.maxHealthAbsorbed.get();
            float damageAbsorbed = Math.min((float)maxHealthAbsorbed, (absorptionRatio = (float)((Double)ModConfig.server.vampiricGlove.absorptionRatio.get()).doubleValue()) * (damageDealt = Math.min(event.getAmount(), event.getEntityLiving().func_110143_aJ())));
            if (damageAbsorbed >= 1.0f) {
                wearer.func_70691_i(damageAbsorbed);
            }
            this.damageEquippedStacks(wearer);
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE_DEFAULT;
    }

    @Override
    protected ResourceLocation getSlimTexture() {
        return TEXTURE_SLIM;
    }
}

