/*
 * Decompiled with CFR 0.152.
 */
package com.micle.totemofreviving.network;

import com.micle.totemofreviving.TotemOfReviving;
import com.micle.totemofreviving.utils.Utils;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class C2SRequestPlayerRevive {
    private final UUID player_uuid;
    private final Hand hand;

    public C2SRequestPlayerRevive(UUID player_uuid, Hand hand) {
        this.player_uuid = player_uuid;
        this.hand = hand;
    }

    public static void encode(C2SRequestPlayerRevive msg, PacketBuffer packet_buffer) {
        packet_buffer.func_179252_a(msg.player_uuid);
        packet_buffer.func_179249_a((Enum)msg.hand);
    }

    public static C2SRequestPlayerRevive decode(PacketBuffer packet_buffer) {
        return new C2SRequestPlayerRevive(packet_buffer.func_179253_g(), (Hand)packet_buffer.func_179257_a(Hand.class));
    }

    public static void handle(C2SRequestPlayerRevive msg, Supplier<NetworkEvent.Context> context_supplier) {
        NetworkEvent.Context context = context_supplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity sender = TotemOfReviving.players.func_177451_a(msg.player_uuid);
            if (sender == null) {
                return;
            }
            ItemStack item = sender.func_184586_b(msg.hand);
            if (item.func_196082_o().func_74762_e("target_index") > TotemOfReviving.players.func_72394_k() - 1 || item.func_196082_o().func_74779_i("target_name").equals("")) {
                sender.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Error getting target! (Try selecting the target again)"), sender.func_110124_au());
            } else {
                ServerPlayerEntity player_to_revive = TotemOfReviving.players.func_152612_a(item.func_196082_o().func_74779_i("target_name"));
                ServerWorld player_to_revive_world = player_to_revive.func_71121_q();
                ServerWorld sender_world = sender.func_71121_q();
                int required_charge = player_to_revive.func_147099_x().func_77444_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_188069_A));
                if (player_to_revive.func_175149_v()) {
                    if (player_to_revive_world.equals(sender_world)) {
                        if (item.func_196082_o().func_74762_e("charge") >= required_charge) {
                            if (item.func_196082_o().func_74764_b("fail_chance")) {
                                int fail_chance = item.func_196082_o().func_74762_e("fail_chance");
                                if (Utils.randomIntRange(0, 100) <= fail_chance) {
                                    item.func_196082_o().func_74768_a("charge", item.func_196082_o().func_74762_e("charge") - required_charge);
                                    item.func_196082_o().func_74768_a("fail_chance", fail_chance - 5 * required_charge);
                                    sender.func_195064_c(new EffectInstance(Effects.field_76436_u, fail_chance * 10 / 2, 1));
                                    return;
                                }
                                item.func_196082_o().func_74768_a("fail_chance", fail_chance - 5 * required_charge);
                            }
                            player_to_revive.func_70634_a(sender.func_226277_ct_(), sender.func_226278_cu_(), sender.func_226281_cx_());
                            player_to_revive.func_71033_a(GameType.SURVIVAL);
                            item.func_196082_o().func_74768_a("charge", item.func_196082_o().func_74762_e("charge") - required_charge);
                            sender.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "Successfully revived " + TextFormatting.DARK_GRAY + player_to_revive.func_145748_c_().getString()), sender.func_110124_au());
                        } else {
                            sender.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "Not enough charge! Required charge is: " + TextFormatting.DARK_GRAY + required_charge), sender.func_110124_au());
                        }
                    } else {
                        sender.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.DARK_GRAY + player_to_revive.func_145748_c_().getString() + TextFormatting.GRAY + " is not in this dimension!"), sender.func_110124_au());
                    }
                } else {
                    sender.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.DARK_GRAY + player_to_revive.func_145748_c_().getString() + TextFormatting.GRAY + " is not dead!"), sender.func_110124_au());
                }
            }
        });
        context.setPacketHandled(true);
    }
}

