/*
 * Decompiled with CFR 0.152.
 */
package com.micle.totemofreviving.network;

import com.micle.totemofreviving.TotemOfReviving;
import com.micle.totemofreviving.utils.Utils;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class C2SRequestTotemCharge {
    private final UUID player_uuid;
    private final Hand hand;
    private final Hand item_charge_hand;

    public C2SRequestTotemCharge(UUID player_uuid, Hand hand, Hand item_charge_hand) {
        this.player_uuid = player_uuid;
        this.hand = hand;
        this.item_charge_hand = item_charge_hand;
    }

    public static void encode(C2SRequestTotemCharge msg, PacketBuffer packet_buffer) {
        packet_buffer.func_179252_a(msg.player_uuid);
        packet_buffer.func_179249_a((Enum)msg.hand);
        packet_buffer.func_179249_a((Enum)msg.item_charge_hand);
    }

    public static C2SRequestTotemCharge decode(PacketBuffer packet_buffer) {
        return new C2SRequestTotemCharge(packet_buffer.func_179253_g(), (Hand)packet_buffer.func_179257_a(Hand.class), (Hand)packet_buffer.func_179257_a(Hand.class));
    }

    public static void handle(C2SRequestTotemCharge msg, Supplier<NetworkEvent.Context> context_supplier) {
        NetworkEvent.Context context = context_supplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity sender = TotemOfReviving.players.func_177451_a(msg.player_uuid);
            if (sender == null) {
                return;
            }
            ItemStack charge_item = sender.func_184586_b(msg.item_charge_hand);
            ItemStack totem_item = sender.func_184586_b(msg.hand);
            charge_item.func_190920_e(charge_item.func_190916_E() - 1);
            totem_item.func_196082_o().func_74768_a("charge", totem_item.func_196082_o().func_74762_e("charge") + 1);
            if (totem_item.func_196082_o().func_74764_b("fail_chance")) {
                int fail_chance = totem_item.func_196082_o().func_74762_e("fail_chance");
                if (Utils.randomIntRange(0, 100) <= fail_chance) {
                    sender.func_184611_a(msg.hand, new ItemStack((IItemProvider)Items.field_190931_a));
                    sender.func_195064_c(new EffectInstance(Effects.field_76436_u, fail_chance * 10 / 2, 1));
                } else {
                    totem_item.func_196082_o().func_74768_a("fail_chance", fail_chance + 5);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

