/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.leosmushrooms.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import net.mcreator.leosmushrooms.LeosMushroomsModElements;
import net.mcreator.leosmushrooms.itemgroup.LeosMushroomsItemGroup;
import net.mcreator.leosmushrooms.procedures.MushroomRegenProcedure;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.item.Item;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

@LeosMushroomsModElements.ModElement.Tag
public class MushroomEntity
extends LeosMushroomsModElements.ModElement {
    public static EntityType entity = null;

    public MushroomEntity(LeosMushroomsModElements instance) {
        super(instance, 24);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new ModelRegisterHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void initElements() {
        entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220321_a(0.6f, 1.8f).func_206830_a("mushroom").setRegistryName("mushroom");
        this.elements.entities.add(() -> entity);
        this.elements.items.add(() -> (Item)new SpawnEggItem(entity, -2371662, -1609216, new Item.Properties().func_200916_a(LeosMushroomsItemGroup.tab)).setRegistryName("mushroom_spawn_egg"));
    }

    @SubscribeEvent
    public void addFeatureToBiomes(BiomeLoadingEvent event) {
        boolean biomeCriteria = false;
        if (new ResourceLocation("leos_mushrooms:mushroom_land").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (!biomeCriteria) {
            return;
        }
        event.getSpawns().getSpawner(EntityClassification.AMBIENT).add(new MobSpawnInfo.Spawners(entity, 20, 4, 6));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(this::setupAttributes);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
    }

    private void setupAttributes() {
        AttributeModifierMap.MutableAttribute ammma = MobEntity.func_233666_p_();
        ammma = ammma.func_233815_a_(Attributes.field_233821_d_, 0.3);
        ammma = ammma.func_233815_a_(Attributes.field_233818_a_, 10.0);
        ammma = ammma.func_233815_a_(Attributes.field_233826_i_, 0.0);
        ammma = ammma.func_233815_a_(Attributes.field_233823_f_, 3.0);
        GlobalEntityTypeAttributes.put((EntityType)entity, (AttributeModifierMap)ammma.func_233813_a_());
    }

    public static class ModelMushroom
    extends EntityModel<Entity> {
        private final ModelRenderer Mushroom;
        private final ModelRenderer leftLeg;
        private final ModelRenderer rightLeg;
        private final ModelRenderer leftArm;
        private final ModelRenderer rightArm;
        private final ModelRenderer headbody;

        public ModelMushroom() {
            this.field_78090_t = 64;
            this.field_78089_u = 64;
            this.Mushroom = new ModelRenderer((Model)this);
            this.Mushroom.func_78793_a(0.0f, 24.0f, 0.0f);
            this.setRotationAngle(this.Mushroom, 0.0f, 3.1416f, 0.0f);
            this.leftLeg = new ModelRenderer((Model)this);
            this.leftLeg.func_78793_a(-2.0f, -3.5f, 0.0f);
            this.Mushroom.func_78792_a(this.leftLeg);
            this.leftLeg.func_78784_a(0, 31).func_228303_a_(-1.5f, -1.5f, -1.5f, 3.0f, 5.0f, 3.0f, 0.0f, false);
            this.rightLeg = new ModelRenderer((Model)this);
            this.rightLeg.func_78793_a(2.0f, -3.5f, 0.0f);
            this.Mushroom.func_78792_a(this.rightLeg);
            this.rightLeg.func_78784_a(12, 31).func_228303_a_(-1.5f, -1.5f, -1.5f, 3.0f, 5.0f, 3.0f, 0.0f, false);
            this.leftArm = new ModelRenderer((Model)this);
            this.leftArm.func_78793_a(-5.0f, -6.0f, 0.0f);
            this.Mushroom.func_78792_a(this.leftArm);
            this.leftArm.func_78784_a(0, 0).func_228303_a_(-1.0f, -1.0f, -1.0f, 2.0f, 4.0f, 2.0f, 0.0f, false);
            this.rightArm = new ModelRenderer((Model)this);
            this.rightArm.func_78793_a(5.0f, -6.0f, 0.0f);
            this.Mushroom.func_78792_a(this.rightArm);
            this.rightArm.func_78784_a(23, 18).func_228303_a_(-1.0f, -1.0f, -1.0f, 2.0f, 4.0f, 2.0f, 0.0f, false);
            this.headbody = new ModelRenderer((Model)this);
            this.headbody.func_78793_a(0.0f, -12.0f, 0.0f);
            this.Mushroom.func_78792_a(this.headbody);
            this.headbody.func_78784_a(0, 0).func_228303_a_(-6.0f, -4.0f, -5.0f, 12.0f, 8.0f, 10.0f, 0.0f, false);
            this.headbody.func_78784_a(0, 18).func_228303_a_(-4.0f, 3.0f, -3.5f, 8.0f, 6.0f, 7.0f, 0.0f, false);
            this.headbody.func_78784_a(24, 25).func_228303_a_(-3.5f, 3.5f, -3.0f, 7.0f, 5.0f, 6.0f, 0.0f, false);
        }

        public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.Mushroom.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_225597_a_(Entity e, float f, float f1, float f2, float f3, float f4) {
            this.rightLeg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * 1.0f * f1;
            this.rightArm.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f + (float)Math.PI)) * f1;
            this.leftArm.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f)) * f1;
            this.leftLeg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * -1.0f * f1;
        }
    }

    public static class CustomEntity
    extends MonsterEntity {
        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 0;
            this.func_94061_f(false);
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.4));
            this.field_70714_bg.func_75776_a(2, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
            this.field_70714_bg.func_75776_a(3, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(4, (Goal)new SwimGoal((MobEntity)this));
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223222_a_;
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source == DamageSource.field_76369_e) {
                return false;
            }
            return super.func_70097_a(source, amount);
        }

        public void func_70030_z() {
            super.func_70030_z();
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            CustomEntity entity = this;
            HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("entity", (Object)entity);
            $_dependencies.put("world", this.field_70170_p);
            MushroomRegenProcedure.executeProcedure($_dependencies);
        }
    }

    private static class ModelRegisterHandler {
        private ModelRegisterHandler() {
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void registerModels(ModelRegistryEvent event) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)entity, renderManager -> new MobRenderer(renderManager, new ModelMushroom(), 0.5f){

                public ResourceLocation func_110775_a(Entity entity) {
                    return new ResourceLocation("leos_mushrooms:textures/mushroom.png");
                }
            });
        }
    }
}

