/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.biomeinfo;

import bl4ckscor3.mod.biomeinfo.Configuration;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;

@Mod(value="biomeinfo")
public class BiomeInfo {
    public static final String MODID = "biomeinfo";
    public static Biome previousBiome;
    public static int displayTime;
    public static int alpha;
    private boolean complete = false;
    private boolean fadingIn = false;

    public BiomeInfo() {
        if (FMLLoader.getDist() == Dist.CLIENT) {
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Configuration.CONFIG_SPEC);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onLoadComplete);
            MinecraftForge.EVENT_BUS.addListener(this::onClientTick);
            MinecraftForge.EVENT_BUS.addListener(this::onRenderGameOverlay);
        }
    }

    public void onLoadComplete(FMLLoadCompleteEvent event) {
        this.complete = true;
    }

    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.complete) {
            if (!this.fadingIn) {
                if (!Configuration.fadeOut() && alpha != 255) {
                    alpha = 255;
                } else if (Configuration.fadeOut()) {
                    if (displayTime > 0) {
                        --displayTime;
                    } else if (alpha > 0) {
                        alpha -= 10;
                    }
                }
            } else if ((alpha += 10) >= 255) {
                this.fadingIn = false;
                displayTime = Configuration.displayTime();
                alpha = 255;
            }
        }
    }

    public void onRenderGameOverlay(RenderGameOverlayEvent.Text event) {
        if (this.complete && Configuration.enabled() && !Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            Minecraft mc = Minecraft.func_71410_x();
            BlockPos pos = mc.func_175606_aa().func_233580_cy_();
            if (mc.field_71441_e != null && mc.field_71441_e.func_195588_v(pos)) {
                Biome biome = mc.field_71441_e.func_226691_t_(pos);
                if (previousBiome != biome) {
                    previousBiome = biome;
                    if (Configuration.fadeIn()) {
                        displayTime = 0;
                        alpha = 0;
                        this.fadingIn = true;
                    } else {
                        displayTime = Configuration.displayTime();
                        alpha = 255;
                    }
                }
                if (alpha > 0) {
                    float scale = (float)Configuration.scale();
                    MatrixStack matrix = event.getMatrixStack();
                    TranslationTextComponent biomeName = new TranslationTextComponent(Util.func_200697_a((String)"biome", (ResourceLocation)mc.field_71441_e.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)biome)));
                    matrix.func_227860_a_();
                    matrix.func_227862_a_(scale, scale, scale);
                    if (Configuration.textShadow()) {
                        mc.field_71466_p.func_243246_a(matrix, (ITextComponent)biomeName, (float)Configuration.posX(), (float)Configuration.posY(), Configuration.color() | alpha << 24);
                    } else {
                        mc.field_71466_p.func_243248_b(matrix, (ITextComponent)biomeName, (float)Configuration.posX(), (float)Configuration.posY(), Configuration.color() | alpha << 24);
                    }
                    matrix.func_227865_b_();
                }
            }
        }
    }

    static {
        displayTime = 0;
        alpha = 0;
    }
}

