/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.jei.JEI")
@ZenRegister
public class JEIManager {
    public static final List<IItemStack> HIDDEN_ITEMS = new ArrayList<IItemStack>();
    public static final List<IFluidStack> HIDDEN_FLUIDS = new ArrayList<IFluidStack>();
    public static final List<String> HIDDEN_RECIPE_CATEGORIES = new ArrayList<String>();
    public static final List<Pair<String, String>> HIDDEN_RECIPES = new ArrayList<Pair<String, String>>();
    public static final Map<IItemStack, String[]> ITEM_DESCRIPTIONS = new HashMap<IItemStack, String[]>();
    public static final Map<IFluidStack, String[]> FLUID_DESCRIPTIONS = new HashMap<IFluidStack, String[]>();

    @ZenCodeType.Method
    public static void hideMod(final String modid, final @ZenCodeType.Optional(value="(name as string) => {return false;}") IRecipeManager.RecipeFilter exclude) {
        CraftTweakerAPI.apply((IAction)new IUndoableAction(){
            List<MCItemStackMutable> collectedStacks;

            public void apply() {
                this.collectedStacks = ForgeRegistries.ITEMS.getEntries().stream().filter(entry -> ((RegistryKey)entry.getKey()).func_240901_a_().func_110624_b().equalsIgnoreCase(modid)).filter(entry -> !exclude.test(((RegistryKey)entry.getKey()).func_240901_a_().func_110623_a())).map(registryKeyItemEntry -> new ItemStack((IItemProvider)registryKeyItemEntry.getValue())).filter(itemStack -> !itemStack.func_190926_b()).map(MCItemStackMutable::new).collect(Collectors.toList());
                HIDDEN_ITEMS.addAll(this.collectedStacks);
            }

            public void undo() {
                this.collectedStacks.forEach(HIDDEN_ITEMS::remove);
            }

            public String describeUndo() {
                return "Undoing JEI hiding all Items from Mod: " + modid;
            }

            public String describe() {
                return "JEI Hiding all Items from Mod: " + modid;
            }

            public boolean shouldApplyOn(LogicalSide side) {
                return !CraftTweakerAPI.isServer();
            }
        });
    }

    @ZenCodeType.Method
    public static void hideRegex(final String regex) {
        final Pattern compile = Pattern.compile(regex);
        CraftTweakerAPI.apply((IAction)new IUndoableAction(){
            List<MCItemStackMutable> collectedStacks;

            public void apply() {
                this.collectedStacks = ForgeRegistries.ITEMS.getEntries().stream().filter(entry -> compile.matcher(((RegistryKey)entry.getKey()).func_240901_a_().toString()).matches()).map(registryKeyItemEntry -> new ItemStack((IItemProvider)registryKeyItemEntry.getValue())).filter(itemStack -> !itemStack.func_190926_b()).map(MCItemStackMutable::new).collect(Collectors.toList());
                HIDDEN_ITEMS.addAll(this.collectedStacks);
            }

            public void undo() {
                this.collectedStacks.forEach(HIDDEN_ITEMS::remove);
            }

            public String describeUndo() {
                return "Undoing JEI hiding all Items from Mod: " + regex;
            }

            public String describe() {
                return "JEI Hiding all Items from by Regex: " + regex;
            }

            public boolean shouldApplyOn(LogicalSide side) {
                return !CraftTweakerAPI.isServer();
            }
        });
    }

    @ZenCodeType.Method
    public static void hideItem(final IItemStack stack) {
        CraftTweakerAPI.apply((IAction)new IUndoableAction(){

            public void apply() {
                HIDDEN_ITEMS.add(stack);
            }

            public void undo() {
                HIDDEN_ITEMS.remove(stack);
            }

            public String describeUndo() {
                return "Undoing JEI hiding Item: " + stack.getCommandString();
            }

            public String describe() {
                return "JEI Hiding Item: " + stack.getCommandString();
            }

            public boolean shouldApplyOn(LogicalSide side) {
                return !CraftTweakerAPI.isServer();
            }
        });
    }

    @ZenCodeType.Method
    public static void hideFluid(final IFluidStack stack) {
        CraftTweakerAPI.apply((IAction)new IUndoableAction(){

            public void apply() {
                HIDDEN_FLUIDS.add(stack);
            }

            public void undo() {
                HIDDEN_FLUIDS.remove(stack);
            }

            public String describeUndo() {
                return "Undoing JEI hiding Fluid: " + stack.getCommandString();
            }

            public String describe() {
                return "JEI Hiding Fluid: " + stack.getCommandString();
            }

            public boolean shouldApplyOn(LogicalSide side) {
                return !CraftTweakerAPI.isServer();
            }
        });
    }

    @ZenCodeType.Method
    public static void addInfo(final IItemStack stack, final String[] string) {
        CraftTweakerAPI.apply((IAction)new IUndoableAction(){

            public void apply() {
                ITEM_DESCRIPTIONS.put(stack, string);
            }

            public void undo() {
                ITEM_DESCRIPTIONS.remove(stack);
            }

            public String describeUndo() {
                return "Undoing adding JEI Info for: " + stack.getCommandString();
            }

            public String describe() {
                return "Adding JEI Info for: " + stack.getCommandString();
            }

            public boolean shouldApplyOn(LogicalSide side) {
                return !CraftTweakerAPI.isServer();
            }
        });
    }

    @ZenCodeType.Method
    public static void addInfo(final IFluidStack stack, final String[] string) {
        CraftTweakerAPI.apply((IAction)new IUndoableAction(){

            public void apply() {
                FLUID_DESCRIPTIONS.put(stack, string);
            }

            public void undo() {
                FLUID_DESCRIPTIONS.remove(stack);
            }

            public String describeUndo() {
                return "Undoing adding JEI Info for: " + stack.getCommandString();
            }

            public String describe() {
                return "Adding JEI Info for: " + stack.getCommandString();
            }

            public boolean shouldApplyOn(LogicalSide side) {
                return !CraftTweakerAPI.isServer();
            }
        });
    }

    @ZenCodeType.Method
    public static void hideCategory(final String category) {
        CraftTweakerAPI.apply((IAction)new IUndoableAction(){

            public void apply() {
                HIDDEN_RECIPE_CATEGORIES.add(category);
            }

            public void undo() {
                HIDDEN_RECIPE_CATEGORIES.remove(category);
            }

            public String describeUndo() {
                return "Undoing JEI hiding Category: " + category;
            }

            public String describe() {
                return "JEI Hiding Category: " + category;
            }

            public boolean shouldApplyOn(LogicalSide side) {
                return !CraftTweakerAPI.isServer();
            }
        });
    }

    @ZenCodeType.Method
    public static void hideRecipe(final String category, final String recipeName) {
        CraftTweakerAPI.apply((IAction)new IUndoableAction(){

            public void apply() {
                HIDDEN_RECIPES.add((Pair<String, String>)Pair.of((Object)category, (Object)recipeName));
            }

            public void undo() {
                HIDDEN_RECIPES.removeIf(next -> ((String)next.getLeft()).equals(category) && ((String)next.getRight()).equals(recipeName));
            }

            public String describeUndo() {
                return "Undoing JEI hiding recipe: " + recipeName + " in category: " + category;
            }

            public String describe() {
                return "JEI Hiding recipe: " + recipeName + " in category: " + category;
            }

            public boolean shouldApplyOn(LogicalSide side) {
                return !CraftTweakerAPI.isServer();
            }
        });
    }
}

