/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.config.json.overrides;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.datafixers.util.Pair;
import corgitaco.betterweather.BetterWeather;
import corgitaco.betterweather.config.json.overrides.BiomeToOverrideStorageJsonStorage;
import corgitaco.betterweather.util.storage.OverrideStorage;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class OverrideDeserializer
implements JsonDeserializer<BiomeToOverrideStorageJsonStorage> {
    public static IdentityHashMap<ResourceLocation, OverrideStorage> processKeys(ObjectOpenHashSet<Pair<Object, JsonElement>> oldMap, Registry<Biome> biomeRegistry) {
        IdentityHashMap<ResourceLocation, OverrideStorage> newMap = new IdentityHashMap<ResourceLocation, OverrideStorage>();
        Map<Biome.Category, List<Biome>> categoryListMap = biomeRegistry.func_239659_c_().stream().map(Map.Entry::getValue).collect(Collectors.groupingBy(Biome::func_201856_r));
        Map biomeDictionaryMap = biomeRegistry.func_239659_c_().stream().flatMap(e -> BiomeDictionary.getTypes((RegistryKey)((RegistryKey)e.getKey())).stream().map(x -> new AbstractMap.SimpleEntry((BiomeDictionary.Type)x, e.getValue()))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        for (Pair pair : oldMap) {
            OverrideStorage overrideStorage;
            ResourceLocation biomeKey;
            Object object = pair.getFirst();
            if (object instanceof BiomeDictionary.Type) {
                for (Biome biome : biomeDictionaryMap.get(object)) {
                    biomeKey = biomeRegistry.func_177774_c((Object)biome);
                    overrideStorage = newMap.getOrDefault(biomeKey, new OverrideStorage());
                    OverrideDeserializer.updateOverrideStorageData(overrideStorage, (JsonElement)pair.getSecond());
                    newMap.put(biomeKey, overrideStorage);
                }
                continue;
            }
            if (object instanceof Biome.Category) {
                for (Biome biome : categoryListMap.get(object)) {
                    biomeKey = biomeRegistry.func_177774_c((Object)biome);
                    overrideStorage = newMap.getOrDefault(biomeKey, new OverrideStorage());
                    OverrideDeserializer.updateOverrideStorageData(overrideStorage, (JsonElement)pair.getSecond());
                    newMap.put(biomeKey, overrideStorage);
                }
                continue;
            }
            if (!(object instanceof Biome)) continue;
            Biome biome = (Biome)object;
            ResourceLocation biomeKey2 = biomeRegistry.func_177774_c((Object)biome);
            OverrideStorage overrideStorage2 = newMap.getOrDefault(biomeKey2, new OverrideStorage());
            OverrideDeserializer.updateOverrideStorageData(overrideStorage2, (JsonElement)pair.getSecond());
            newMap.put(biomeKey2, overrideStorage2);
        }
        return newMap;
    }

    public static void updateOverrideStorageData(OverrideStorage storage, JsonElement element) {
        JsonObject jsonObject = element.getAsJsonObject();
        if (jsonObject.has("tempModifier")) {
            storage.setTempModifier(jsonObject.get("tempModifier").getAsDouble());
        }
        if (jsonObject.has("humidityModifier")) {
            storage.setHumidityModifier(jsonObject.get("humidityModifier").getAsDouble());
        }
        if (jsonObject.has("cropGrowthMultiplier")) {
            storage.setFallBack(jsonObject.get("cropGrowthMultiplier").getAsDouble());
        }
        if (jsonObject.has("cropOverrides")) {
            JsonObject cropOverrides = jsonObject.get("cropOverrides").getAsJsonObject();
            IdentityHashMap<Block, Double> cropMulitplierMap = new IdentityHashMap<Block, Double>();
            for (Map.Entry jsonElementEntry : cropOverrides.entrySet()) {
                Optional blockOptional = Registry.field_212618_g.func_241873_b(new ResourceLocation((String)jsonElementEntry.getKey()));
                if (blockOptional.isPresent()) {
                    cropMulitplierMap.put((Block)blockOptional.get(), ((JsonElement)jsonElementEntry.getValue()).getAsDouble());
                    continue;
                }
                BetterWeather.LOGGER.error("Block ID: \"" + jsonElementEntry + "\" is not a valid block ID in the registry, the override will not be applied...");
            }
            storage.setBlockToCropGrowthMultiplierMap(cropMulitplierMap);
        }
        if (element.getAsJsonObject().has("client")) {
            JsonObject client = element.getAsJsonObject().get("client").getAsJsonObject();
            if (client.has("targetFoliageHexColor")) {
                storage.getClientStorage().setTargetFoliageHexColor(client.get("targetFoliageHexColor").getAsString());
            }
            if (client.has("foliageColorBlendStrength")) {
                storage.getClientStorage().setFoliageColorBlendStrength(client.get("foliageColorBlendStrength").getAsDouble());
            }
            if (client.has("targetGrassHexColor")) {
                storage.getClientStorage().setTargetGrassHexColor(client.get("targetGrassHexColor").getAsString());
            }
            if (client.has("grassColorBlendStrength")) {
                storage.getClientStorage().setGrassColorBlendStrength(client.get("grassColorBlendStrength").getAsDouble());
            }
            if (client.has("targetSkyHexColor")) {
                storage.getClientStorage().setTargetSkyHexColor(client.get("targetSkyHexColor").getAsString());
            }
            if (client.has("skyColorBlendStrength")) {
                storage.getClientStorage().setSkyColorBlendStrength(client.get("skyColorBlendStrength").getAsDouble());
            }
            if (client.has("targetFogHexColor")) {
                storage.getClientStorage().setTargetFogHexColor(client.get("targetFogHexColor").getAsString());
            }
            if (client.has("fogColorBlendStrength")) {
                storage.getClientStorage().setFogColorBlendStrength(client.get("fogColorBlendStrength").getAsDouble());
            }
            storage.getClientStorage().parseHexColors();
        }
    }

    public BiomeToOverrideStorageJsonStorage deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        StringBuilder errorBuilder = new StringBuilder();
        MutableRegistry biomeRegistry = BetterWeather.biomeRegistryEarlyAccess == null ? Minecraft.func_71410_x().field_71441_e.func_241828_r().func_243612_b(Registry.field_239720_u_) : BetterWeather.biomeRegistryEarlyAccess;
        ObjectOpenHashSet biomeObjects = new ObjectOpenHashSet();
        Map uncastedCropOverrides = null;
        Set entrySet = object.entrySet();
        for (Map.Entry entry : entrySet) {
            if (((String)entry.getKey()).equals("cropOverrides")) {
                uncastedCropOverrides = (Map)new Gson().fromJson(new Gson().toJson((JsonElement)entry.getValue()), Map.class);
                continue;
            }
            String key = (String)entry.getKey();
            Object value = this.extractKey(errorBuilder, key, (Registry<Biome>)biomeRegistry);
            if (value == null) continue;
            biomeObjects.add((Object)new Pair(value, entry.getValue()));
        }
        if (uncastedCropOverrides == null) {
            uncastedCropOverrides = new HashMap();
        }
        if (!errorBuilder.toString().isEmpty()) {
            throw new IllegalArgumentException("Errors were found in your override file: " + errorBuilder.toString());
        }
        IdentityHashMap<ResourceLocation, OverrideStorage> biomeToOverrideStorage = OverrideDeserializer.processKeys((ObjectOpenHashSet<Pair<Object, JsonElement>>)biomeObjects, (Registry<Biome>)biomeRegistry);
        IdentityHashMap<Block, Double> cropToMultiplierMap = new IdentityHashMap<Block, Double>();
        if (!uncastedCropOverrides.isEmpty()) {
            IdentityHashMap<String, Double> blockIDToMultiplierMap = new IdentityHashMap<String, Double>(uncastedCropOverrides);
            blockIDToMultiplierMap.forEach((blockId, multiplier) -> {
                Optional blockOptional = Registry.field_212618_g.func_241873_b(new ResourceLocation(blockId));
                if (blockOptional.isPresent()) {
                    cropToMultiplierMap.put((Block)blockOptional.get(), (Double)multiplier);
                } else {
                    BetterWeather.LOGGER.error("Block ID: \"" + blockId + "\" is not a valid block ID in the registry, the override will not be applied...");
                }
            });
        }
        return new BiomeToOverrideStorageJsonStorage(biomeToOverrideStorage, cropToMultiplierMap);
    }

    private Object extractKey(StringBuilder errorBuilder, String key, Registry<Biome> biomeRegistry) {
        Biome.Category value;
        String lowerCaseKey = key.toLowerCase();
        if (lowerCaseKey.startsWith("category/")) {
            try {
                value = Biome.Category.valueOf((String)lowerCaseKey.substring("category/".length()).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                errorBuilder.append(key.substring("category/".length())).append(" is not a Biome Category Value!\n");
                return null;
            }
        } else if (lowerCaseKey.startsWith("forge/")) {
            value = BiomeDictionary.Type.getType((String)lowerCaseKey.substring("forge/".length()).toUpperCase(), (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
        } else if (lowerCaseKey.startsWith("biome/")) {
            value = biomeRegistry.func_241873_b(new ResourceLocation(lowerCaseKey.substring("biome/".length()))).orElse(null);
            if (value == null) {
                errorBuilder.append(lowerCaseKey.substring("biome/".length())).append(" is not a biome in this world!\n");
                return null;
            }
        } else {
            errorBuilder.append(key).append(" is not a Biome/Category/Forge identifier\n");
            return null;
        }
        return value;
    }

    public static class ObjectToOverrideStorageJsonStorageSerializer
    implements JsonSerializer<BiomeToOverrideStorageJsonStorage.ObjectToOverrideStorageJsonStorage> {
        public JsonElement serialize(BiomeToOverrideStorageJsonStorage.ObjectToOverrideStorageJsonStorage src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject result = new JsonObject();
            for (Map.Entry<Object, OverrideStorage> entry : src.getObjectToOverrideStorage().entrySet()) {
                Object object = entry.getKey();
                OverrideStorage overrideStorage = entry.getValue();
                if (object instanceof Biome.Category) {
                    Biome.Category category = (Biome.Category)object;
                    result.add("category/" + category.toString(), (JsonElement)this.overrideStorageJsonObject(overrideStorage));
                    continue;
                }
                if (object instanceof BiomeDictionary.Type) {
                    BiomeDictionary.Type type = (BiomeDictionary.Type)object;
                    result.add("forge/" + type.toString(), (JsonElement)this.overrideStorageJsonObject(overrideStorage));
                    continue;
                }
                if (object instanceof ResourceLocation) {
                    ResourceLocation location = (ResourceLocation)object;
                    result.add("biome/" + location.toString(), (JsonElement)this.overrideStorageJsonObject(overrideStorage));
                    continue;
                }
                BetterWeather.LOGGER.error("Could not serialize object of class type: " + object.getClass().getName());
            }
            return result;
        }

        public JsonObject overrideStorageJsonObject(OverrideStorage storage) {
            JsonObject jsonObject = new JsonObject();
            if (storage.getTempModifier() != Double.MAX_VALUE) {
                jsonObject.addProperty("tempModifier", (Number)storage.getTempModifier());
            }
            if (storage.getHumidityModifier() != Double.MAX_VALUE) {
                jsonObject.addProperty("humidityModifier", (Number)storage.getHumidityModifier());
            }
            if (storage.getFallBack() != Double.MAX_VALUE) {
                jsonObject.addProperty("cropMultiplierDefault", (Number)storage.getFallBack());
            }
            if (!storage.getBlockToCropGrowthMultiplierMap().isEmpty()) {
                jsonObject.add("cropOverrides", new Gson().toJsonTree(storage.getBlockToCropGrowthMultiplierMap(), Map.class));
            }
            this.getClientJsonData(storage, jsonObject);
            return jsonObject;
        }

        private void getClientJsonData(OverrideStorage storage, JsonObject jsonObject) {
            OverrideStorage.OverrideClientStorage clientStorage = storage.getClientStorage();
            if (clientStorage != null) {
                JsonObject clientJsonObject = new JsonObject();
                if (!clientStorage.getTargetFoliageHexColor().isEmpty()) {
                    clientJsonObject.addProperty("targetFoliageHexColor", clientStorage.getTargetFoliageHexColor());
                }
                if (clientStorage.getFoliageColorBlendStrength() != Double.MAX_VALUE) {
                    clientJsonObject.addProperty("foliageColorBlendStrength", (Number)clientStorage.getFoliageColorBlendStrength());
                }
                if (!clientStorage.getTargetGrassHexColor().isEmpty()) {
                    clientJsonObject.addProperty("targetGrassHexColor", clientStorage.getTargetGrassHexColor());
                }
                if (clientStorage.getGrassColorBlendStrength() != Double.MAX_VALUE) {
                    clientJsonObject.addProperty("grassColorBlendStrength", (Number)clientStorage.getGrassColorBlendStrength());
                }
                if (!clientStorage.getTargetSkyHexColor().isEmpty()) {
                    clientJsonObject.addProperty("targetSkyHexColor", clientStorage.getTargetSkyHexColor());
                }
                if (clientStorage.getSkyColorBlendStrength() != Double.MAX_VALUE) {
                    clientJsonObject.addProperty("skyColorBlendStrength", (Number)clientStorage.getSkyColorBlendStrength());
                }
                if (!clientStorage.getTargetFogHexColor().isEmpty()) {
                    clientJsonObject.addProperty("targetFogHexColor", clientStorage.getTargetFogHexColor());
                }
                if (clientStorage.getFogColorBlendStrength() != Double.MAX_VALUE) {
                    clientJsonObject.addProperty("fogColorBlendStrength", (Number)clientStorage.getFogColorBlendStrength());
                }
                jsonObject.add("client", (JsonElement)clientJsonObject);
            }
        }
    }
}

