/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.datastorage;

import corgitaco.betterweather.api.SeasonData;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class BetterWeatherSeasonData
extends WorldSavedData {
    public static String DATA_NAME = "betterweather:season_data";
    private static final BetterWeatherSeasonData CLIENT_CACHE = new BetterWeatherSeasonData();
    private int seasonTime;
    private int seasonCycleLength;
    private String season = SeasonData.SeasonVal.SPRING.toString();
    private String subseason;
    private boolean isForced;

    public BetterWeatherSeasonData() {
        super(DATA_NAME);
    }

    public BetterWeatherSeasonData(String s) {
        super(s);
    }

    public static BetterWeatherSeasonData get(IWorld world) {
        if (!(world instanceof ServerWorld)) {
            return CLIENT_CACHE;
        }
        ServerWorld overWorld = ((ServerWorld)world).func_201672_e().func_73046_m().func_71218_a(World.field_234918_g_);
        DimensionSavedDataManager data = overWorld.func_217481_x();
        BetterWeatherSeasonData weatherData = (BetterWeatherSeasonData)data.func_215752_a(BetterWeatherSeasonData::new, DATA_NAME);
        if (weatherData == null) {
            weatherData = new BetterWeatherSeasonData();
            data.func_215757_a((WorldSavedData)weatherData);
        }
        return weatherData;
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.setSeasonTime(nbt.func_74762_e("seasontime"));
        this.setSeasonCycleLength(nbt.func_74762_e("seasoncyclelength"));
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        compound.func_74768_a("seasontime", this.seasonTime);
        compound.func_74768_a("seasoncyclelength", this.seasonCycleLength);
        return compound;
    }

    public int getSeasonTime() {
        return this.seasonTime;
    }

    public void setSeasonTime(int seasonTime) {
        this.seasonTime = seasonTime;
        this.func_76185_a();
    }

    public SeasonData.SeasonVal getSeason() {
        return SeasonData.SeasonVal.valueOf(this.season);
    }

    public void setSeason(String season) {
        this.season = season;
        this.func_76185_a();
    }

    public int getSeasonCycleLength() {
        return this.seasonCycleLength;
    }

    public void setSeasonCycleLength(int seasonCycleLength) {
        this.seasonCycleLength = seasonCycleLength;
    }

    public void setSubseason(String subseason) {
        this.subseason = subseason;
    }

    public boolean isForced() {
        return this.isForced;
    }

    public void setForced(boolean forced) {
        this.isForced = forced;
    }
}

