/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.datastorage.network.packet;

import corgitaco.betterweather.datastorage.BetterWeatherSeasonData;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.IWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class SeasonPacket {
    private final int seasonTime;
    private final int seasonCycleLength;

    public SeasonPacket(int seasonTime, int seasonCycleLength) {
        this.seasonTime = seasonTime;
        this.seasonCycleLength = seasonCycleLength;
    }

    public static void writeToPacket(SeasonPacket packet, PacketBuffer buf) {
        buf.writeInt(packet.seasonTime);
        buf.writeInt(packet.seasonCycleLength);
    }

    public static SeasonPacket readFromPacket(PacketBuffer buf) {
        return new SeasonPacket(buf.readInt(), buf.readInt());
    }

    public static void handle(SeasonPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                Minecraft minecraft = Minecraft.func_71410_x();
                if (minecraft.field_71441_e != null && minecraft.field_71439_g != null) {
                    BetterWeatherSeasonData.get((IWorld)minecraft.field_71441_e).setSeasonTime(message.seasonTime);
                    BetterWeatherSeasonData.get((IWorld)minecraft.field_71441_e).setSeasonCycleLength(message.seasonCycleLength);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

