/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.weatherevent;

import corgitaco.betterweather.api.BetterWeatherEntryPoint;
import corgitaco.betterweather.api.weatherevent.BetterWeatherID;
import corgitaco.betterweather.api.weatherevent.WeatherData;
import corgitaco.betterweather.api.weatherevent.WeatherEvent;
import corgitaco.betterweather.datastorage.BetterWeatherEventData;
import corgitaco.betterweather.datastorage.network.NetworkHandler;
import corgitaco.betterweather.datastorage.network.packet.WeatherEventPacket;
import corgitaco.betterweather.datastorage.network.packet.util.RefreshRenderersPacket;
import corgitaco.betterweather.helper.IsWeatherForced;
import corgitaco.betterweather.weatherevent.weatherevents.AcidRain;
import corgitaco.betterweather.weatherevent.weatherevents.Blizzard;
import corgitaco.betterweather.weatherevent.weatherevents.Clouded;
import corgitaco.betterweather.weatherevent.weatherevents.LightRain;
import corgitaco.betterweather.weatherevent.weatherevents.vanilla.Clear;
import corgitaco.betterweather.weatherevent.weatherevents.vanilla.DefaultRain;
import corgitaco.betterweather.weatherevent.weatherevents.vanilla.DefaultThunder;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.ServerWorldInfo;

public class WeatherEventSystem {
    public static final BetterWeatherID ACID_RAIN = new BetterWeatherID("betterweather", "ACID_RAIN");
    public static final BetterWeatherID BLIZZARD = new BetterWeatherID("betterweather", "BLIZZARD");
    public static final BetterWeatherID CLEAR = new BetterWeatherID("betterweather", "CLEAR");
    public static final BetterWeatherID CLOUDED = new BetterWeatherID("betterweather", "CLOUDED");
    public static final BetterWeatherID LIGHT_RAIN = new BetterWeatherID("betterweather", "LIGHT_RAIN");
    public static final BetterWeatherID DEFAULT = new BetterWeatherID("betterweather", "DEFAULT");
    public static final BetterWeatherID DEFAULT_THUNDER = new BetterWeatherID("betterweather", "DEFAULT_THUNDER");
    public static HashMap<BetterWeatherID, Double> WEATHER_EVENT_CONTROLLER = new HashMap();
    public static HashMap<BetterWeatherID, WeatherEvent> WEATHER_EVENTS = new HashMap();
    private static boolean isFadingOut = true;
    private static BetterWeatherID cachedEvent = CLEAR;

    public static void fillWeatherEventsMapAndWeatherEventController() {
        for (WeatherEvent weatherEvent : BetterWeatherEntryPoint.WEATHER_EVENTS) {
            WEATHER_EVENTS.put(weatherEvent.getID(), weatherEvent);
            WEATHER_EVENT_CONTROLLER.put(weatherEvent.getID(), weatherEvent.getDefaultChance());
        }
    }

    public static void addDefaultWeatherEvents() {
        BetterWeatherEntryPoint.WEATHER_EVENTS.add((Object)new Blizzard());
        BetterWeatherEntryPoint.WEATHER_EVENTS.add((Object)new AcidRain());
        BetterWeatherEntryPoint.WEATHER_EVENTS.add((Object)new DefaultRain());
        BetterWeatherEntryPoint.WEATHER_EVENTS.add((Object)new DefaultThunder());
        BetterWeatherEntryPoint.WEATHER_EVENTS.add((Object)new Clear());
        BetterWeatherEntryPoint.WEATHER_EVENTS.add((Object)new Clouded());
        BetterWeatherEntryPoint.WEATHER_EVENTS.add((Object)new LightRain());
    }

    public static void updateWeatherEventPacket(ServerWorld world, List<ServerPlayerEntity> players, boolean justJoined) {
        BetterWeatherID currentEvent = BetterWeatherEventData.get((IWorld)world).getEventID();
        if (!cachedEvent.equals(currentEvent) || justJoined) {
            players.forEach(player -> NetworkHandler.sendToClient(player, new WeatherEventPacket(currentEvent.toString())));
            cachedEvent = currentEvent;
        }
    }

    public static void rollWeatherEventChance(Random random, ServerWorld world, boolean isRaining, ServerWorldInfo worldInfo, List<ServerPlayerEntity> players) {
        if (world.field_73004_o == 0.0f) {
            if (isRaining && !BetterWeatherEventData.get((IWorld)world).isWeatherForced()) {
                AtomicBoolean weatherEventWasSet = new AtomicBoolean(false);
                WEATHER_EVENT_CONTROLLER.forEach((event, chance) -> {
                    if (event != CLEAR && random.nextDouble() < chance) {
                        weatherEventWasSet.set(true);
                        BetterWeatherEventData.get((IWorld)world).setEvent(event.toString());
                    }
                });
                if (!weatherEventWasSet.get()) {
                    BetterWeatherEventData.get((IWorld)world).setEvent(DEFAULT.toString());
                }
                players.forEach(player -> {
                    NetworkHandler.sendToClient(player, new WeatherEventPacket(BetterWeatherEventData.get((IWorld)world).getEventString()));
                    if (WeatherData.currentWeatherEvent.refreshPlayerRenderer()) {
                        NetworkHandler.sendToClient(player, new RefreshRenderersPacket());
                    }
                });
            }
        } else if (!isRaining) {
            if (world.field_73004_o == 1.0f) {
                isFadingOut = true;
            } else if (world.field_73004_o <= 0.011f && isFadingOut) {
                boolean refreshRenderersPost = WeatherData.currentWeatherEvent.refreshPlayerRenderer();
                BetterWeatherEventData.get((IWorld)world).setEvent(CLEAR.toString());
                ((IsWeatherForced)worldInfo).setWeatherForced(false);
                BetterWeatherEventData.get((IWorld)world).setWeatherForced(((IsWeatherForced)worldInfo).isWeatherForced());
                players.forEach(player -> {
                    NetworkHandler.sendToClient(player, new WeatherEventPacket(BetterWeatherEventData.get((IWorld)world).getEventString()));
                    if (refreshRenderersPost) {
                        NetworkHandler.sendToClient(player, new RefreshRenderersPacket());
                    }
                });
                isFadingOut = false;
            }
        }
    }
}

