/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.weatherevent.weatherevents.vanilla;

import corgitaco.betterweather.BetterWeatherUtil;
import corgitaco.betterweather.api.weatherevent.BetterWeatherID;
import corgitaco.betterweather.api.weatherevent.WeatherEvent;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public class DefaultThunder
extends WeatherEvent {
    public DefaultThunder() {
        super(new BetterWeatherID("betterweather", "DEFAULT_THUNDER"), 0.4);
    }

    @Override
    public void worldTick(ServerWorld world, int tickSpeed, long worldTime) {
    }

    private void spawnLightning(Chunk chunk, ServerWorld world) {
        BlockPos blockpos;
        ChunkPos chunkpos = chunk.func_76632_l();
        boolean flag = world.func_72896_J();
        int i = chunkpos.func_180334_c();
        int j = chunkpos.func_180333_d();
        IProfiler iprofiler = world.func_217381_Z();
        iprofiler.func_76320_a("thunder");
        if (flag && world.func_72911_I() && world.field_73012_v.nextInt(100000) == 0 && world.func_175727_C(blockpos = this.adjustPosToNearbyEntity(world.func_217383_a(i, 0, j, 15), world))) {
            boolean flag1;
            DifficultyInstance difficultyinstance = world.func_175649_E(blockpos);
            boolean bl = flag1 = world.func_82736_K().func_223586_b(GameRules.field_223601_d) && world.field_73012_v.nextDouble() < (double)difficultyinstance.func_180168_b() * 0.01;
            if (flag1) {
                SkeletonHorseEntity skeletonhorseentity = (SkeletonHorseEntity)EntityType.field_200742_ah.func_200721_a((World)world);
                skeletonhorseentity.func_190691_p(true);
                skeletonhorseentity.func_70873_a(0);
                skeletonhorseentity.func_70107_b((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p());
                world.func_217376_c((Entity)skeletonhorseentity);
            }
            LightningBoltEntity lightningboltentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a((World)world);
            lightningboltentity.func_233576_c_(Vector3d.func_237492_c_((Vector3i)blockpos));
            lightningboltentity.func_233623_a_(flag1);
            world.func_217376_c((Entity)lightningboltentity);
        }
    }

    @Override
    public void clientTick(ClientWorld world, int tickSpeed, long worldTime, Minecraft mc) {
    }

    @Override
    public boolean renderWeather(Minecraft mc, ClientWorld world, LightTexture lightTexture, int ticks, float partialTicks, double x, double y, double z) {
        return false;
    }

    protected BlockPos adjustPosToNearbyEntity(BlockPos pos, ServerWorld world) {
        BlockPos blockpos = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, pos);
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(blockpos, new BlockPos(blockpos.func_177958_n(), world.func_217301_I(), blockpos.func_177952_p())).func_186662_g(3.0);
        List list = world.func_175647_a(LivingEntity.class, axisalignedbb, entity -> entity != null && entity.func_70089_S() && world.func_226660_f_(entity.func_233580_cy_()));
        if (!list.isEmpty()) {
            return ((LivingEntity)list.get(world.field_73012_v.nextInt(list.size()))).func_233580_cy_();
        }
        if (blockpos.func_177956_o() == -1) {
            blockpos = blockpos.func_177981_b(2);
        }
        return blockpos;
    }

    @Override
    public Color modifySkyColor(Color biomeColor, Color returnColor, @Nullable Color seasonTargetColor, float rainStrength) {
        return BetterWeatherUtil.blendColor(returnColor, BetterWeatherUtil.DEFAULT_THUNDER_SKY, rainStrength);
    }

    @Override
    public Color modifyCloudColor(Color returnColor, float rainStrength) {
        return BetterWeatherUtil.blendColor(returnColor, BetterWeatherUtil.DEFAULT_THUNDER_CLOUDS, rainStrength);
    }

    @Override
    public Color modifyFogColor(Color biomeColor, Color returnColor, @Nullable Color seasonTargetColor, float rainStrength) {
        return BetterWeatherUtil.blendColor(returnColor, BetterWeatherUtil.DEFAULT_THUNDER_FOG, rainStrength);
    }

    @Override
    public void tickLiveChunks(Chunk chunk, ServerWorld world) {
        this.spawnLightning(chunk, world);
    }

    @Override
    public boolean fillBlocksWithWater() {
        return true;
    }

    @Override
    public boolean spawnSnowInFreezingClimates() {
        return true;
    }

    @Override
    public boolean weatherParticlesAndSound(ActiveRenderInfo renderInfo, Minecraft mc) {
        return false;
    }

    @Override
    public boolean drippingLeaves() {
        return true;
    }

    @Override
    public float dayLightDarkness() {
        return 2.5f;
    }
}

