/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import vazkii.botania.api.recipe.IElvenTradeRecipe;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ElvenTradeRecipeCategory
implements IRecipeCategory<IElvenTradeRecipe> {
    public static final ResourceLocation UID = ResourceLocationHelper.prefix("elven_trade");
    private final String localizedName = I18n.func_135052_a((String)"botania.nei.elvenTrade", (Object[])new Object[0]);
    private final IDrawable background;
    private final IDrawable overlay;
    private final IDrawable icon;

    public ElvenTradeRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(145, 95);
        this.overlay = guiHelper.createDrawable(ResourceLocationHelper.prefix("textures/gui/elven_trade_overlay.png"), 0, 15, 140, 90);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.alfPortal));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends IElvenTradeRecipe> getRecipeClass() {
        return IElvenTradeRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(IElvenTradeRecipe recipe, IIngredients iIngredients) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Ingredient i : recipe.func_192400_c()) {
            builder.add(Arrays.asList(i.func_193365_a()));
        }
        iIngredients.setInputLists(VanillaTypes.ITEM, (List)builder.build());
        iIngredients.setOutputs(VanillaTypes.ITEM, (List)ImmutableList.copyOf(recipe.getOutputs()));
    }

    public void draw(IElvenTradeRecipe recipe, MatrixStack ms, double mouseX, double mouseY) {
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        this.overlay.draw(ms, 0, 4);
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        TextureAtlasSprite sprite = MiscellaneousIcons.INSTANCE.alfPortalTex.func_229314_c_();
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder wr = tess.func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        int startX = 22;
        int startY = 25;
        int stopX = 70;
        int stopY = 73;
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        wr.func_227888_a_(mat, (float)startX, (float)startY, 0.0f).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_181675_d();
        wr.func_227888_a_(mat, (float)startX, (float)stopY, 0.0f).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_181675_d();
        wr.func_227888_a_(mat, (float)stopX, (float)stopY, 0.0f).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_181675_d();
        wr.func_227888_a_(mat, (float)stopX, (float)startY, 0.0f).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_181675_d();
        tess.func_78381_a();
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IElvenTradeRecipe recipe, @Nonnull IIngredients ingredients) {
        int index = 0;
        int posX = 42;
        for (List o : ingredients.getInputs(VanillaTypes.ITEM)) {
            recipeLayout.getItemStacks().init(index, true, posX, 0);
            recipeLayout.getItemStacks().set(index, o);
            ++index;
            posX += 18;
        }
        for (int i = 0; i < ingredients.getOutputs(VanillaTypes.ITEM).size(); ++i) {
            List stacks = (List)ingredients.getOutputs(VanillaTypes.ITEM).get(i);
            recipeLayout.getItemStacks().init(index + i, false, 93 + i % 2 * 20, 41 + i / 2 * 20);
            recipeLayout.getItemStacks().set(index + i, stacks);
        }
    }
}

