/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.OrechidOutput;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.recipe.IElvenTradeRecipe;
import vazkii.botania.client.core.handler.CorporeaInputHandler;
import vazkii.botania.client.gui.crafting.ContainerCraftingHalo;
import vazkii.botania.client.integration.jei.BreweryRecipeCategory;
import vazkii.botania.client.integration.jei.ElvenTradeRecipeCategory;
import vazkii.botania.client.integration.jei.ManaPoolRecipeCategory;
import vazkii.botania.client.integration.jei.PetalApothecaryRecipeCategory;
import vazkii.botania.client.integration.jei.PureDaisyRecipeCategory;
import vazkii.botania.client.integration.jei.RunicAltarRecipeCategory;
import vazkii.botania.client.integration.jei.TerraPlateRecipeCategory;
import vazkii.botania.client.integration.jei.crafting.AncientWillRecipeWrapper;
import vazkii.botania.client.integration.jei.crafting.CompositeLensRecipeWrapper;
import vazkii.botania.client.integration.jei.crafting.TerraPickTippingRecipeWrapper;
import vazkii.botania.client.integration.jei.orechid.OrechidIgnemRecipeCategory;
import vazkii.botania.client.integration.jei.orechid.OrechidRecipeCategory;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.block.tile.TileAlfPortal;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.crafting.LexiconElvenTradeRecipe;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.recipe.AncientWillRecipe;
import vazkii.botania.common.crafting.recipe.CompositeLensRecipe;
import vazkii.botania.common.crafting.recipe.TerraPickTippingRecipe;
import vazkii.botania.common.item.ItemLaputaShard;
import vazkii.botania.common.item.ItemManaTablet;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.brew.ItemBrewBase;
import vazkii.botania.common.item.equipment.bauble.ItemFlightTiara;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;
import vazkii.botania.common.lib.ResourceLocationHelper;

@JeiPlugin
public class JEIBotaniaPlugin
implements IModPlugin {
    private static final ResourceLocation ID = ResourceLocationHelper.prefix("main");

    public void registerItemSubtypes(@Nonnull ISubtypeRegistration registry) {
        registry.registerSubtypeInterpreter(ModItems.brewVial, ItemBrewBase::getSubtype);
        registry.registerSubtypeInterpreter(ModItems.brewFlask, ItemBrewBase::getSubtype);
        registry.registerSubtypeInterpreter(ModItems.incenseStick, ItemBrewBase::getSubtype);
        registry.registerSubtypeInterpreter(ModItems.bloodPendant, ItemBrewBase::getSubtype);
        registry.registerSubtypeInterpreter(ModItems.flightTiara, stack -> String.valueOf(ItemFlightTiara.getVariant(stack)));
        registry.registerSubtypeInterpreter((Item)ModItems.lexicon, stack -> String.valueOf(ItemNBTHelper.getBoolean(stack, "botania:elven_unlock", false)));
        registry.registerSubtypeInterpreter(ModItems.laputaShard, stack -> String.valueOf(ItemLaputaShard.getShardLevel(stack)));
        registry.registerSubtypeInterpreter(ModItems.terraPick, stack -> String.valueOf(ItemTerraPick.getLevel(stack)) + ItemTerraPick.isTipped(stack));
        registry.registerSubtypeInterpreter(ModItems.manaTablet, stack -> String.valueOf(((IManaItem)ModItems.manaTablet).getMana(stack)) + ItemManaTablet.isStackCreative(stack));
        for (Item item : new Item[]{ModItems.manaRing, ModItems.manaRingGreater}) {
            registry.registerSubtypeInterpreter(item, stack -> String.valueOf(((IManaItem)item).getMana(stack)));
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new PureDaisyRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new ManaPoolRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new PetalApothecaryRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new RunicAltarRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new ElvenTradeRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new BreweryRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new OrechidRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new OrechidIgnemRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new TerraPlateRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        registration.getCraftingCategory().addCategoryExtension(AncientWillRecipe.class, AncientWillRecipeWrapper::new);
        registration.getCraftingCategory().addCategoryExtension(TerraPickTippingRecipe.class, TerraPickTippingRecipeWrapper::new);
        registration.getCraftingCategory().addCategoryExtension(CompositeLensRecipe.class, CompositeLensRecipeWrapper::new);
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registry) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        registry.addRecipes(ModRecipeTypes.getRecipes((World)world, ModRecipeTypes.BREW_TYPE).values(), BreweryRecipeCategory.UID);
        registry.addRecipes(ModRecipeTypes.getRecipes((World)world, ModRecipeTypes.PURE_DAISY_TYPE).values(), PureDaisyRecipeCategory.UID);
        registry.addRecipes(ModRecipeTypes.getRecipes((World)world, ModRecipeTypes.PETAL_TYPE).values(), PetalApothecaryRecipeCategory.UID);
        registry.addRecipes(ModRecipeTypes.getRecipes((World)world, ModRecipeTypes.ELVEN_TRADE_TYPE).values(), ElvenTradeRecipeCategory.UID);
        registry.addRecipes(ModRecipeTypes.getRecipes((World)world, ModRecipeTypes.RUNE_TYPE).values(), RunicAltarRecipeCategory.UID);
        registry.addRecipes(TilePool.manaInfusionRecipes((World)Minecraft.func_71410_x().field_71441_e), ManaPoolRecipeCategory.UID);
        registry.addRecipes(ModRecipeTypes.getRecipes((World)world, ModRecipeTypes.TERRA_PLATE_TYPE).values(), TerraPlateRecipeCategory.UID);
        ArrayList<OrechidOutput> weights = new ArrayList<OrechidOutput>(BotaniaAPI.instance().getOrechidWeights());
        weights.sort(Comparator.naturalOrder());
        registry.addRecipes(weights, OrechidRecipeCategory.UID);
        weights = new ArrayList<OrechidOutput>(BotaniaAPI.instance().getNetherOrechidWeights());
        weights.sort(Comparator.naturalOrder());
        registry.addRecipes(weights, OrechidIgnemRecipeCategory.UID);
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registry) {
        registry.addRecipeTransferHandler(ContainerCraftingHalo.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 10, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.brewery), new ResourceLocation[]{BreweryRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.alfPortal), new ResourceLocation[]{ElvenTradeRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.manaPool), new ResourceLocation[]{ManaPoolRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.creativePool), new ResourceLocation[]{ManaPoolRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.dilutedPool), new ResourceLocation[]{ManaPoolRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.fabulousPool), new ResourceLocation[]{ManaPoolRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.defaultAltar), new ResourceLocation[]{PetalApothecaryRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.forestAltar), new ResourceLocation[]{PetalApothecaryRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.plainsAltar), new ResourceLocation[]{PetalApothecaryRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.mountainAltar), new ResourceLocation[]{PetalApothecaryRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.fungalAltar), new ResourceLocation[]{PetalApothecaryRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.swampAltar), new ResourceLocation[]{PetalApothecaryRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.desertAltar), new ResourceLocation[]{PetalApothecaryRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.taigaAltar), new ResourceLocation[]{PetalApothecaryRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.mesaAltar), new ResourceLocation[]{PetalApothecaryRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.mossyAltar), new ResourceLocation[]{PetalApothecaryRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModSubtiles.orechid), new ResourceLocation[]{OrechidRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModSubtiles.orechidFloating), new ResourceLocation[]{OrechidRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModSubtiles.orechidIgnem), new ResourceLocation[]{OrechidIgnemRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModSubtiles.orechidIgnemFloating), new ResourceLocation[]{OrechidIgnemRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModSubtiles.pureDaisy), new ResourceLocation[]{PureDaisyRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModSubtiles.pureDaisyFloating), new ResourceLocation[]{PureDaisyRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.runeAltar), new ResourceLocation[]{RunicAltarRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.terraPlate), new ResourceLocation[]{TerraPlateRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.autocraftingHalo), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.craftingHalo), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        IRecipeManager recipeRegistry = jeiRuntime.getRecipeManager();
        for (IElvenTradeRecipe recipe : TileAlfPortal.elvenTradeRecipes((World)Minecraft.func_71410_x().field_71441_e)) {
            if (recipe instanceof LexiconElvenTradeRecipe) continue;
            NonNullList<Ingredient> inputs = recipe.func_192400_c();
            List<ItemStack> outputs = recipe.getOutputs();
            if (inputs.size() != 1 || outputs.size() != 1 || !recipe.containsItem(outputs.get(0))) continue;
            recipeRegistry.hideRecipe((Object)recipe, ElvenTradeRecipeCategory.UID);
        }
        RecipeManager recipeManager = Minecraft.func_71410_x().field_71441_e.func_199532_z();
        recipeManager.func_215367_a(ResourceLocationHelper.prefix("petal_apothecary/daybloom_motif")).ifPresent(r -> recipeRegistry.hideRecipe(r, PetalApothecaryRecipeCategory.UID));
        recipeManager.func_215367_a(ResourceLocationHelper.prefix("petal_apothecary/nightshade_motif")).ifPresent(r -> recipeRegistry.hideRecipe(r, PetalApothecaryRecipeCategory.UID));
        jeiRuntime.getIngredientManager().removeIngredientsAtRuntime(VanillaTypes.ITEM, Arrays.asList(new ItemStack((IItemProvider)ModSubtiles.labelia), new ItemStack((IItemProvider)ModSubtiles.labeliaFloating)));
        CorporeaInputHandler.jeiPanelSupplier = () -> {
            Object o = jeiRuntime.getIngredientListOverlay().getIngredientUnderMouse();
            if (o == null && Minecraft.func_71410_x().field_71462_r == jeiRuntime.getRecipesGui()) {
                o = jeiRuntime.getRecipesGui().getIngredientUnderMouse();
            }
            if (o == null) {
                o = jeiRuntime.getBookmarkOverlay().getIngredientUnderMouse();
            }
            if (o instanceof ItemStack) {
                return (ItemStack)o;
            }
            return ItemStack.field_190927_a;
        };
        CorporeaInputHandler.supportedGuiFilter = gui -> gui instanceof ContainerScreen || gui instanceof IRecipesGui;
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }
}

