/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.orechid;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import vazkii.botania.api.internal.OrechidOutput;
import vazkii.botania.common.crafting.StateIngredientHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public abstract class OrechidRecipeCategoryBase
implements IRecipeCategory<OrechidOutput> {
    private final IDrawableStatic background;
    private final String localizedName;
    private final IDrawableStatic overlay;
    private final IDrawable icon;
    private final ItemStack iconStack;
    private final ItemStack inputStack;

    public OrechidRecipeCategoryBase(IGuiHelper guiHelper, ItemStack iconStack, ItemStack inputStack, String localizedName) {
        this.overlay = guiHelper.createDrawable(ResourceLocationHelper.prefix("textures/gui/pure_daisy_overlay.png"), 0, 0, 64, 44);
        this.background = guiHelper.createBlankDrawable(96, 44);
        this.localizedName = localizedName;
        this.icon = guiHelper.createDrawableIngredient((Object)iconStack);
        this.iconStack = iconStack;
        this.inputStack = inputStack;
    }

    @Nonnull
    public Class<? extends OrechidOutput> getRecipeClass() {
        return OrechidOutput.class;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(OrechidOutput recipe, IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)this.inputStack);
        int myWeight = recipe.field_76292_a;
        int amount = Math.max(1, Math.round((float)myWeight * 64.0f / OrechidRecipeCategoryBase.getTotalOreWeight(this.getOreWeights(), myWeight)));
        List<ItemStack> stackList = StateIngredientHelper.toStackList(recipe.getOutput());
        stackList.forEach(s -> s.func_190920_e(amount));
        ingredients.setOutputLists(VanillaTypes.ITEM, Collections.singletonList(stackList));
    }

    public static float getTotalOreWeight(List<OrechidOutput> weights, int myWeight) {
        return weights.stream().map(OrechidOutput::getWeight).reduce(Integer::sum).orElse(myWeight * 64 * 64).intValue();
    }

    protected abstract List<OrechidOutput> getOreWeights();

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull OrechidOutput recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 9, 12);
        itemStacks.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        itemStacks.init(1, true, 39, 12);
        itemStacks.set(1, this.iconStack);
        itemStacks.init(2, true, 68, 12);
        itemStacks.set(2, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    public void draw(OrechidOutput recipe, MatrixStack ms, double mouseX, double mouseY) {
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        this.overlay.draw(ms, 17, 0);
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
    }
}

