/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TilePylon;

public class BlockPylon
extends BlockModWaterloggable
implements ITileEntityProvider {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)21.0, (double)14.0);
    public final Variant variant;

    public BlockPylon(@Nonnull Variant v, AbstractBlock.Properties builder) {
        super(builder);
        this.variant = v;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return SHAPE;
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public float getEnchantPowerBonus(BlockState state, IWorldReader world, BlockPos pos) {
        return this.variant.enchantPowerBonus;
    }

    @Nonnull
    public TileEntity func_196283_a_(@Nonnull IBlockReader world) {
        return new TilePylon();
    }

    public static enum Variant {
        MANA(8.0f, 0.5f, 0.5f, 1.0f),
        NATURA(15.0f, 0.5f, 1.0f, 0.5f),
        GAIA(15.0f, 1.0f, 0.5f, 1.0f);

        public final float enchantPowerBonus;
        public final float r;
        public final float g;
        public final float b;

        private Variant(float epb, float r, float g, float b) {
            this.enchantPowerBonus = epb;
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public Block getTargetBlock() {
            return this == MANA ? ModBlocks.enchanter : ModBlocks.alfPortal;
        }
    }
}

