/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntitySpecialFlower;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.ModSubtiles;

public class SubTileBergamute
extends TileEntitySpecialFlower {
    private static final int RANGE = 4;
    private static final Set<SubTileBergamute> existingFlowers = Collections.newSetFromMap(new WeakHashMap());
    private static final Set<ISound> mutedSounds = Collections.newSetFromMap(new WeakHashMap());
    private boolean disabled = false;

    public SubTileBergamute() {
        super(ModSubtiles.BERGAMUTE);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.func_145831_w().field_72995_K) {
            this.disabled = false;
            for (Direction dir : Direction.values()) {
                int redstoneSide = this.func_145831_w().func_175651_c(this.func_174877_v().func_177972_a(dir), dir);
                if (redstoneSide <= 0) continue;
                this.disabled = true;
                break;
            }
            existingFlowers.add(this);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        existingFlowers.remove(this);
    }

    @Nullable
    private static SubTileBergamute getBergamuteNearby(double x, double y, double z) {
        for (SubTileBergamute f : existingFlowers) {
            if (f.disabled || !(f.getEffectivePos().func_218140_a(x, y, z, true) <= 16.0)) continue;
            return f;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean muteSound(ISound sound) {
        SubTileBergamute berg = SubTileBergamute.getBergamuteNearby(sound.func_147649_g(), sound.func_147654_h(), sound.func_147651_i());
        if (berg != null && mutedSounds.add(sound) && Math.random() < 0.5) {
            int color = 50943;
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 5);
            berg.func_145831_w().func_195594_a((IParticleData)data, (double)berg.getEffectivePos().func_177958_n() + 0.3 + Math.random() * 0.5, (double)berg.getEffectivePos().func_177956_o() + 0.5 + Math.random() * 0.5, (double)berg.getEffectivePos().func_177952_p() + 0.3 + Math.random() * 0.5, 0.0, 0.0, 0.0);
        }
        return berg != null;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.getEffectivePos(), 4.0);
    }
}

