/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.IHourglassTrigger;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileExposedSimpleInventory;
import vazkii.botania.common.item.ModItems;

public class TileHourglass
extends TileExposedSimpleInventory
implements ITickableTileEntity {
    private static final String TAG_TIME = "time";
    private static final String TAG_TIME_FRACTION = "timeFraction";
    private static final String TAG_FLIP = "flip";
    private static final String TAG_FLIP_TICKS = "flipTicks";
    private static final String TAG_LOCK = "lock";
    private static final String TAG_MOVE = "move";
    private int time = 0;
    public float timeFraction = 0.0f;
    public float lastFraction = 0.0f;
    public boolean flip = false;
    public int flipTicks = 0;
    public boolean lock = false;
    public boolean move = true;

    public TileHourglass() {
        super(ModTiles.HOURGLASS);
    }

    private boolean isDust() {
        ItemStack stack = this.getItemHandler().func_70301_a(0);
        return !stack.func_190926_b() && stack.func_77973_b() == ModItems.manaPowder;
    }

    public void func_73660_a() {
        int totalTime = this.getTotalTime();
        boolean dust = this.isDust();
        if (totalTime > 0 || dust) {
            if (this.move && !dust) {
                ++this.time;
            }
            if (this.time >= totalTime) {
                this.time = 0;
                this.flip = !this.flip;
                this.flipTicks = 4;
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(true)), 1);
                    this.field_145850_b.func_205220_G_().func_205360_a(this.field_174879_c, (Object)this.func_195044_w().func_177230_c(), 4);
                }
                for (Direction facing : Direction.values()) {
                    BlockPos pos = this.func_174877_v().func_177972_a(facing);
                    BlockState state = this.field_145850_b.func_180495_p(pos);
                    if (!(state.func_177230_c() instanceof IHourglassTrigger)) continue;
                    ((IHourglassTrigger)state.func_177230_c()).onTriggeredByHourglass(this.field_145850_b, pos, this);
                }
            }
            this.lastFraction = this.timeFraction;
            this.timeFraction = (float)this.time / (float)totalTime;
        } else {
            this.time = 0;
            this.lastFraction = 0.0f;
            this.timeFraction = 0.0f;
        }
        if (this.flipTicks > 0) {
            --this.flipTicks;
        }
    }

    public void onManaCollide() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isDust()) {
                ++this.time;
            } else {
                this.move = !this.move;
            }
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    public int getTotalTime() {
        ItemStack stack = this.getItemHandler().func_70301_a(0);
        if (stack.func_190926_b()) {
            return 0;
        }
        return TileHourglass.getStackItemTime(stack) * stack.func_190916_E();
    }

    public static int getStackItemTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (stack.func_77973_b() == Blocks.field_150354_m.func_199767_j()) {
            return 20;
        }
        if (stack.func_77973_b() == Blocks.field_196611_F.func_199767_j()) {
            return 200;
        }
        if (stack.func_77973_b() == Blocks.field_150425_aM.func_199767_j()) {
            return 1200;
        }
        if (stack.func_77973_b() == ModItems.manaPowder) {
            return 1;
        }
        return 0;
    }

    public int getColor() {
        ItemStack stack = this.getItemHandler().func_70301_a(0);
        if (stack.func_190926_b()) {
            return 0;
        }
        if (stack.func_77973_b() == Blocks.field_150354_m.func_199767_j()) {
            return 16772169;
        }
        if (stack.func_77973_b() == Blocks.field_196611_F.func_199767_j()) {
            return 15292416;
        }
        if (stack.func_77973_b() == Blocks.field_150425_aM.func_199767_j()) {
            return 5914927;
        }
        if (stack.func_77973_b() == ModItems.manaPowder) {
            return 240639;
        }
        return 0;
    }

    @Override
    protected Inventory createItemHandler() {
        return new Inventory(1){

            public boolean func_94041_b(int index, ItemStack stack) {
                return !stack.func_190926_b() && (stack.func_77973_b() == Blocks.field_150354_m.func_199767_j() || stack.func_77973_b() == Blocks.field_196611_F.func_199767_j() || stack.func_77973_b() == Blocks.field_150425_aM.func_199767_j() || stack.func_77973_b() == ModItems.manaPowder);
            }
        };
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.time = 0;
            this.timeFraction = 0.0f;
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    @Override
    public void writePacketNBT(CompoundNBT tag) {
        super.writePacketNBT(tag);
        tag.func_74768_a(TAG_TIME, this.time);
        tag.func_74776_a(TAG_TIME_FRACTION, this.timeFraction);
        tag.func_74757_a(TAG_FLIP, this.flip);
        tag.func_74768_a(TAG_FLIP_TICKS, this.flipTicks);
        tag.func_74757_a(TAG_MOVE, this.move);
        tag.func_74757_a(TAG_LOCK, this.lock);
    }

    @Override
    public void readPacketNBT(CompoundNBT tag) {
        super.readPacketNBT(tag);
        this.time = tag.func_74762_e(TAG_TIME);
        this.timeFraction = tag.func_74760_g(TAG_TIME_FRACTION);
        this.flip = tag.func_74767_n(TAG_FLIP);
        this.flipTicks = tag.func_74762_e(TAG_FLIP_TICKS);
        this.move = tag.func_74767_n(TAG_MOVE);
        this.lock = tag.func_74767_n(TAG_LOCK);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(MatrixStack ms) {
        Minecraft mc = Minecraft.func_71410_x();
        int x = mc.func_228018_at_().func_198107_o() / 2 + 10;
        int y = mc.func_228018_at_().func_198087_p() / 2 - 10;
        ItemStack stack = this.getItemHandler().func_70301_a(0);
        if (!stack.func_190926_b()) {
            mc.func_175599_af().func_175042_a(stack, x, y);
            mc.func_175599_af().func_175030_a(mc.field_71466_p, stack, x, y);
            int time = this.getTotalTime();
            String timeStr = StringUtils.func_76337_a((int)time);
            mc.field_71466_p.func_238405_a_(ms, timeStr, (float)(x + 20), (float)y, this.getColor());
            String status = "";
            if (this.lock) {
                status = "locked";
            }
            if (!this.move) {
                String string = status = status.isEmpty() ? "stopped" : "lockedStopped";
            }
            if (!status.isEmpty()) {
                mc.field_71466_p.func_238405_a_(ms, I18n.func_135052_a((String)("botaniamisc." + status), (Object[])new Object[0]), (float)(x + 20), (float)(y + 12), this.getColor());
            }
        }
    }
}

