/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.LazyValue;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.api.recipe.ITerraPlateRecipe;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.botania.common.network.PacketHandler;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;

public class TileTerraPlate
extends TileMod
implements ISparkAttachable,
ITickableTileEntity {
    public static final LazyValue<IMultiblock> MULTIBLOCK = new LazyValue(() -> PatchouliAPI.get().makeMultiblock((String[][])new String[][]{{"___", "_P_", "___"}, {"RLR", "L0L", "RLR"}}, new Object[]{Character.valueOf('P'), ModBlocks.terraPlate, Character.valueOf('R'), "#botania:terra_plate_base", Character.valueOf('0'), "#botania:terra_plate_base", Character.valueOf('L'), "#forge:storage_blocks/lapis"}));
    private static final String TAG_MANA = "mana";
    private int mana;

    public TileTerraPlate() {
        super(ModTiles.TERRA_PLATE);
    }

    public void func_73660_a() {
        List<ItemStack> items;
        Inventory inv;
        ITerraPlateRecipe recipe;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean removeMana = true;
        if (this.hasValidPlatform() && (recipe = this.getCurrentRecipe(inv = new Inventory((items = this.getItems()).toArray(new ItemStack[0])))) != null) {
            removeMana = false;
            ISparkEntity spark = this.getAttachedSpark();
            if (spark != null) {
                SparkHelper.getSparksAround(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, spark.getNetwork()).filter(otherSpark -> spark != otherSpark && otherSpark.getAttachedTile() instanceof IManaPool).forEach(os -> os.registerTransfer(spark));
            }
            if (this.mana > 0) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
                int proportion = Float.floatToIntBits(this.getCompletion());
                PacketHandler.sendToNearby(this.field_145850_b, this.func_174877_v(), (Object)new PacketBotaniaEffect(PacketBotaniaEffect.EffectType.TERRA_PLATE, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), proportion));
            }
            if (this.mana >= recipe.getMana()) {
                for (ItemStack item : items) {
                    item.func_190918_g(1);
                }
                ItemEntity item = new ItemEntity(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.2, (double)this.func_174877_v().func_177952_p() + 0.5, recipe.func_77572_b((IInventory)inv));
                item.func_213317_d(Vector3d.field_186680_a);
                this.field_145850_b.func_217376_c((Entity)item);
                this.field_145850_b.func_184148_a(null, item.func_226277_ct_(), item.func_226278_cu_(), item.func_226281_cx_(), ModSounds.terrasteelCraft, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.mana = 0;
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            }
        }
        if (removeMana) {
            this.receiveMana(-1000);
        }
    }

    private List<ItemStack> getItems() {
        List itemEntities = this.field_145850_b.func_175647_a(ItemEntity.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1)), EntityPredicates.field_94557_a);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemEntity entity : itemEntities) {
            if (entity.func_92059_d().func_190926_b()) continue;
            stacks.add(entity.func_92059_d());
        }
        return stacks;
    }

    private Inventory getInventory() {
        List<ItemStack> items = this.getItems();
        return new Inventory(items.toArray(new ItemStack[0]));
    }

    @Nullable
    private ITerraPlateRecipe getCurrentRecipe(Inventory items) {
        return this.field_145850_b.func_199532_z().func_215371_a(ModRecipeTypes.TERRA_PLATE_TYPE, (IInventory)items, this.field_145850_b).orElse(null);
    }

    private boolean isActive() {
        return this.getCurrentRecipe(this.getInventory()) != null;
    }

    private boolean hasValidPlatform() {
        return ((IMultiblock)MULTIBLOCK.func_179281_c()).validate(this.field_145850_b, this.func_174877_v().func_177977_b()) != null;
    }

    @Override
    public void writePacketNBT(CompoundNBT cmp) {
        cmp.func_74768_a(TAG_MANA, this.mana);
    }

    @Override
    public void readPacketNBT(CompoundNBT cmp) {
        this.mana = cmp.func_74762_e(TAG_MANA);
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean isFull() {
        ITerraPlateRecipe recipe = this.getCurrentRecipe(this.getInventory());
        return recipe == null || this.getCurrentMana() >= recipe.getMana();
    }

    @Override
    public void receiveMana(int mana) {
        this.mana = Math.max(0, this.mana + mana);
        this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return this.isActive();
    }

    @Override
    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    @Override
    public void attachSpark(ISparkEntity entity) {
    }

    @Override
    public ISparkEntity getAttachedSpark() {
        List sparks = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(this.field_174879_c.func_177984_a(), this.field_174879_c.func_177984_a().func_177982_a(1, 1, 1)), (Predicate)Predicates.instanceOf(ISparkEntity.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ISparkEntity)e;
        }
        return null;
    }

    @Override
    public boolean areIncomingTranfersDone() {
        return !this.isActive();
    }

    @Override
    public int getAvailableSpaceForMana() {
        ITerraPlateRecipe recipe = this.getCurrentRecipe(this.getInventory());
        return recipe == null ? 0 : Math.max(0, recipe.getMana() - this.getCurrentMana());
    }

    public float getCompletion() {
        ITerraPlateRecipe recipe = this.getCurrentRecipe(this.getInventory());
        if (recipe == null) {
            return 0.0f;
        }
        return (float)this.getCurrentMana() / (float)recipe.getMana();
    }

    public int getComparatorLevel() {
        int val = (int)((double)this.getCompletion() * 15.0);
        if (this.getCurrentMana() > 0) {
            val = Math.max(val, 1);
        }
        return val;
    }
}

