/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import vazkii.botania.api.recipe.IRuneAltarRecipe;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.recipe.RecipeUtils;

public class RecipeRuneAltar
implements IRuneAltarRecipe {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> inputs;
    private final int mana;

    public RecipeRuneAltar(ResourceLocation id, ItemStack output, int mana, Ingredient ... inputs) {
        Preconditions.checkArgument((inputs.length <= 16 ? 1 : 0) != 0);
        Preconditions.checkArgument((mana <= 100000 ? 1 : 0) != 0);
        this.id = id;
        this.output = output;
        this.inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])inputs);
        this.mana = mana;
    }

    public boolean func_77569_a(IInventory inv, @Nonnull World world) {
        return RecipeUtils.matches(this.inputs, inv, null);
    }

    @Nonnull
    public final ItemStack func_77571_b() {
        return this.output;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull IInventory inv) {
        return this.func_77571_b().func_77946_l();
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return this.inputs;
    }

    @Nonnull
    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)ModBlocks.runeAltar);
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipeTypes.RUNE_SERIALIZER;
    }

    @Override
    public int getManaUsage() {
        return this.mana;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RecipeRuneAltar> {
        @Nonnull
        public RecipeRuneAltar read(@Nonnull ResourceLocation id, @Nonnull JsonObject json) {
            ItemStack output = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"output"));
            int mana = JSONUtils.func_151203_m((JsonObject)json, (String)"mana");
            JsonArray ingrs = JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients");
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            for (JsonElement e : ingrs) {
                inputs.add(Ingredient.func_199802_a((JsonElement)e));
            }
            return new RecipeRuneAltar(id, output, mana, inputs.toArray(new Ingredient[0]));
        }

        public RecipeRuneAltar read(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buf) {
            Ingredient[] inputs = new Ingredient[buf.func_150792_a()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = Ingredient.func_199566_b((PacketBuffer)buf);
            }
            ItemStack output = buf.func_150791_c();
            int mana = buf.func_150792_a();
            return new RecipeRuneAltar(id, output, mana, inputs);
        }

        public void write(@Nonnull PacketBuffer buf, @Nonnull RecipeRuneAltar recipe) {
            buf.func_150787_b(recipe.func_192400_c().size());
            for (Ingredient input : recipe.func_192400_c()) {
                input.func_199564_a(buf);
            }
            buf.writeItemStack(recipe.func_77571_b(), false);
            buf.func_150787_b(recipe.getManaUsage());
        }
    }
}

