/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import vazkii.botania.api.recipe.ITerraPlateRecipe;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.recipe.RecipeUtils;

public class RecipeTerraPlate
implements ITerraPlateRecipe {
    private final ResourceLocation id;
    private final int mana;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;

    public RecipeTerraPlate(ResourceLocation id, int mana, NonNullList<Ingredient> inputs, ItemStack output) {
        this.id = id;
        this.mana = mana;
        this.inputs = inputs;
        this.output = output;
    }

    @Override
    public int getMana() {
        return this.mana;
    }

    public boolean func_77569_a(IInventory inv, @Nonnull World world) {
        int nonEmptySlots = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            if (inv.func_70301_a(i).func_190916_E() > 1) {
                return false;
            }
            ++nonEmptySlots;
        }
        IntOpenHashSet usedSlots = new IntOpenHashSet(inv.func_70302_i_());
        return RecipeUtils.matches(this.inputs, inv, (IntSet)usedSlots) && usedSlots.size() == nonEmptySlots;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull IInventory inv) {
        return this.output.func_77946_l();
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.output;
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return this.inputs;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<RecipeTerraPlate> func_199559_b() {
        return ModRecipeTypes.TERRA_PLATE_SERIALIZER;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RecipeTerraPlate> {
        @Nonnull
        public RecipeTerraPlate read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            int mana = JSONUtils.func_151203_m((JsonObject)json, (String)"mana");
            JsonArray ingrs = JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients");
            Object[] ingredients = new Ingredient[ingrs.size()];
            for (int i = 0; i < ingrs.size(); ++i) {
                ingredients[i] = Ingredient.func_199802_a((JsonElement)ingrs.get(i));
            }
            ItemStack output = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new RecipeTerraPlate(recipeId, mana, (NonNullList<Ingredient>)NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])ingredients), output);
        }

        public RecipeTerraPlate read(@Nonnull ResourceLocation recipeId, PacketBuffer buffer) {
            int mana = buffer.func_150792_a();
            Object[] ingredients = new Ingredient[buffer.func_150792_a()];
            for (int i = 0; i < ingredients.length; ++i) {
                ingredients[i] = Ingredient.func_199566_b((PacketBuffer)buffer);
            }
            ItemStack output = buffer.func_150791_c();
            return new RecipeTerraPlate(recipeId, mana, (NonNullList<Ingredient>)NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])ingredients), output);
        }

        public void write(PacketBuffer buffer, RecipeTerraPlate recipe) {
            buffer.func_150787_b(recipe.mana);
            buffer.func_150787_b(recipe.func_192400_c().size());
            for (Ingredient ingr : recipe.func_192400_c()) {
                ingr.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.output);
        }
    }
}

