/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.StateIngredientBlocks;
import vazkii.botania.common.crafting.StateIngredientHelper;

public class StateIngredientTag
extends StateIngredientBlocks {
    private final ResourceLocation tag;

    public StateIngredientTag(ResourceLocation id) {
        super((Collection<Block>)ImmutableSet.of());
        this.tag = id;
    }

    @Nonnull
    protected ITag<Block> resolve() {
        return TagCollectionManager.func_242178_a().func_241835_a().func_241834_b(this.tag);
    }

    @Override
    public boolean test(BlockState state) {
        return this.resolve().func_230235_a_((Object)state.func_177230_c());
    }

    @Override
    public BlockState pick(Random random) {
        return ((Block)this.resolve().func_205596_a(random)).func_176223_P();
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "tag");
        object.addProperty("tag", this.tag.toString());
        return object;
    }

    @Override
    @Nonnull
    protected List<Block> getBlocks() {
        return this.resolve().func_230236_b_();
    }

    @Override
    public List<BlockState> getDisplayed() {
        return this.resolve().func_230236_b_().stream().map(Block::func_176223_P).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public StateIngredient resolveAndFilter(UnaryOperator<List<Block>> operator) {
        if (this.resolve().func_230236_b_().isEmpty()) {
            return null;
        }
        List list = (List)operator.apply(this.getBlocks());
        if (list != null) {
            return list.isEmpty() ? null : StateIngredientHelper.of(list);
        }
        return this;
    }

    public ResourceLocation getTagId() {
        return this.tag;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.tag.equals((Object)((StateIngredientTag)o).tag);
    }

    @Override
    public int hashCode() {
        return this.tag.hashCode();
    }

    @Override
    public String toString() {
        return "StateIngredientTag{" + this.tag + "}";
    }
}

