/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.entity.EntityManaBurst;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.item.ModItems;

public class EntityManaStorm
extends Entity {
    private static final String TAG_TIME = "time";
    private static final String TAG_BURST_COLOR = "burstColor";
    private static final String TAG_BURSTS_FIRED = "burstsFired";
    private static final String TAG_DEATH_TIME = "deathTime";
    public static final int TOTAL_BURSTS = 250;
    public static final int DEATH_TIME = 200;
    public int liveTime;
    public int burstColor;
    public int burstsFired;
    public int deathTime;

    public EntityManaStorm(EntityType<EntityManaStorm> type, World world) {
        super(type, world);
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.liveTime;
        int diffTime = Math.max(1, 30 - (int)((float)this.liveTime / 45.0f));
        if (this.burstsFired < 250 && this.liveTime % diffTime == 0) {
            if (!this.field_70170_p.field_72995_K) {
                this.spawnBurst();
            }
            ++this.burstsFired;
        }
        if (this.burstsFired >= 250) {
            ++this.deathTime;
            if (this.deathTime >= 200) {
                this.func_70106_y();
                this.field_70170_p.func_217398_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 8.0f, true, Explosion.Mode.DESTROY);
            }
        }
    }

    private void spawnBurst() {
        EntityManaBurst burst = (EntityManaBurst)ModEntities.MANA_BURST.func_200721_a(this.field_70170_p);
        burst.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        float motionModifier = 0.5f;
        burst.setColor(this.burstColor);
        burst.setMana(120);
        burst.setStartingMana(340);
        burst.setMinManaLoss(50);
        burst.setManaLossPerTick(1.0f);
        burst.setGravity(0.0f);
        burst.setSourceLens(new ItemStack((IItemProvider)ModItems.lensStorm));
        Vector3 motion = new Vector3(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).normalize().multiply(motionModifier);
        burst.setBurstMotion(motion.x, motion.y, motion.z);
        this.field_70170_p.func_217376_c((Entity)burst);
    }

    protected void func_70037_a(@Nonnull CompoundNBT cmp) {
        this.liveTime = cmp.func_74762_e(TAG_TIME);
        this.burstColor = cmp.func_74762_e(TAG_BURST_COLOR);
        this.burstsFired = cmp.func_74762_e(TAG_BURSTS_FIRED);
        this.deathTime = cmp.func_74762_e(TAG_DEATH_TIME);
    }

    protected void func_213281_b(@Nonnull CompoundNBT cmp) {
        cmp.func_74768_a(TAG_TIME, this.liveTime);
        cmp.func_74768_a(TAG_BURST_COLOR, this.burstColor);
        cmp.func_74768_a(TAG_BURSTS_FIRED, this.burstsFired);
        cmp.func_74768_a(TAG_DEATH_TIME, this.deathTime);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

