/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.impl.corporea;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import vazkii.botania.api.corporea.ICorporeaRequest;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.common.impl.corporea.AbstractCorporeaNode;

public class ForgeCapCorporeaNode
extends AbstractCorporeaNode {
    protected final IItemHandler inv;

    public ForgeCapCorporeaNode(World world, BlockPos pos, IItemHandler inv, ICorporeaSpark spark) {
        super(world, pos, spark);
        this.inv = inv;
    }

    @Override
    public List<ItemStack> countItems(ICorporeaRequest request) {
        return this.iterateOverSlots(request, false);
    }

    @Override
    public List<ItemStack> extractItems(ICorporeaRequest request) {
        return this.iterateOverSlots(request, true);
    }

    protected List<ItemStack> iterateOverSlots(ICorporeaRequest request, boolean doit) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = this.inv.getSlots() - 1; i >= 0; --i) {
            ItemStack stackAt = this.inv.getStackInSlot(i);
            if (!request.getMatcher().test(stackAt)) continue;
            request.trackFound(stackAt.func_190916_E());
            int rem = Math.min(stackAt.func_190916_E(), request.getStillNeeded() == -1 ? stackAt.func_190916_E() : request.getStillNeeded());
            if (rem <= 0) continue;
            request.trackSatisfied(rem);
            if (doit) {
                ItemStack copy = stackAt.func_77946_l();
                builder.addAll(ForgeCapCorporeaNode.breakDownBigStack(this.inv.extractItem(i, rem, false)));
                this.getSpark().onItemExtracted(copy);
                request.trackExtracted(rem);
                continue;
            }
            builder.add((Object)this.inv.extractItem(i, rem, true));
        }
        return builder.build();
    }
}

