/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import org.openzen.zencode.java.ZenCodeType;
import vazkii.botania.api.internal.OrechidOutput;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.impl.BotaniaAPIImpl;
import vazkii.botania.common.integration.crafttweaker.actions.ActionAddOrechidOre;
import vazkii.botania.common.integration.crafttweaker.actions.ActionClearOrechidList;
import vazkii.botania.common.integration.crafttweaker.actions.ActionRemoveOrechidOre;

@ZenRegister
@ZenCodeType.Name(value="mods.botania.Orechid")
public class OrechidManager {
    private final Supplier<List<OrechidOutput>> target;
    private final String name;
    @ZenCodeType.Field(value="main")
    public static final OrechidManager MAIN = new OrechidManager(() -> BotaniaAPIImpl.weights, "Orechid");
    @ZenCodeType.Field(value="nether")
    public static final OrechidManager NETHER = new OrechidManager(() -> BotaniaAPIImpl.netherWeights, "Orechid Ignem");

    public OrechidManager(Supplier<List<OrechidOutput>> target, String name) {
        this.target = target;
        this.name = name;
    }

    @ZenCodeType.Method
    public void registerOreWeight(StateIngredient ingredient, int weight) {
        CraftTweakerAPI.apply((IAction)new ActionAddOrechidOre(ingredient, weight, this));
    }

    @ZenCodeType.Method
    public void removeOreWeight(BlockState state) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveOrechidOre(state, this));
    }

    @ZenCodeType.Method
    public void clear() {
        CraftTweakerAPI.apply((IAction)new ActionClearOrechidList(this));
    }

    public List<OrechidOutput> get() {
        return this.target.get();
    }

    public String getName() {
        return this.name;
    }
}

