/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;
import vazkii.botania.client.core.handler.TooltipHandler;
import vazkii.botania.common.advancements.ManaGunTrigger;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.entity.EntityManaBurst;

public class ItemManaGun
extends Item
implements IManaUsingItem {
    private static final String TAG_LENS = "lens";
    private static final String TAG_CLIP = "clip";
    private static final String TAG_CLIP_POS = "clipPos";
    private static final String TAG_COOLDOWN = "cooldown";
    private static final int CLIP_SLOTS = 6;
    private static final int COOLDOWN = 30;

    public ItemManaGun(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        int effCd = 30;
        EffectInstance effect = player.func_70660_b(Effects.field_76422_e);
        if (effect != null) {
            effCd -= (effect.func_76458_c() + 1) * 8;
        }
        if (player.func_225608_bj_() && ItemManaGun.hasClip(stack)) {
            ItemManaGun.rotatePos(stack);
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187839_fV, SoundCategory.PLAYERS, 0.6f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            if (!world.field_72995_K) {
                ItemStack lens = ItemManaGun.getLens(stack);
                ItemsRemainingRenderHandler.send(player, lens, -2);
                this.setCooldown(stack, effCd);
            }
            return ActionResult.func_233538_a_((Object)stack, (boolean)world.field_72995_K);
        }
        if (this.getCooldown(stack) == 0) {
            EntityManaBurst burst = this.getBurst(player, stack, true, hand);
            if (burst != null && ManaItemHandler.instance().requestManaExact(stack, player, burst.getMana(), true)) {
                if (!world.field_72995_K) {
                    world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), ModSounds.manaBlaster, SoundCategory.PLAYERS, 0.6f, 1.0f);
                    world.func_217376_c((Entity)burst);
                    ManaGunTrigger.INSTANCE.trigger((ServerPlayerEntity)player, stack);
                    this.setCooldown(stack, effCd);
                } else {
                    player.func_213317_d(player.func_213322_ci().func_178788_d(burst.func_213322_ci().func_216372_d(0.1, 0.3, 0.1)));
                }
            } else if (!world.field_72995_K) {
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187750_dc, SoundCategory.PLAYERS, 0.6f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            }
            return ActionResult.func_233538_a_((Object)stack, (boolean)world.field_72995_K);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public static boolean isSugoiKawaiiDesuNe(ItemStack stack) {
        return stack.func_200301_q().getString().equalsIgnoreCase("desu gun");
    }

    @Nonnull
    public BurstProperties getBurstProps(PlayerEntity player, ItemStack stack, boolean request, Hand hand) {
        int maxMana = 120;
        int color = 0x20FF20;
        int ticksBeforeManaLoss = 60;
        float manaLossPerTick = 4.0f;
        float motionModifier = 5.0f;
        float gravity = 0.0f;
        BurstProperties props = new BurstProperties(maxMana, ticksBeforeManaLoss, manaLossPerTick, gravity, motionModifier, color);
        ItemStack lens = ItemManaGun.getLens(stack);
        if (!lens.func_190926_b()) {
            ((ILens)lens.func_77973_b()).apply(lens, props);
        }
        return props;
    }

    private EntityManaBurst getBurst(PlayerEntity player, ItemStack stack, boolean request, Hand hand) {
        EntityManaBurst burst = new EntityManaBurst(player);
        BurstProperties props = this.getBurstProps(player, stack, request, hand);
        burst.setSourceLens(ItemManaGun.getLens(stack));
        if (!request || ManaItemHandler.instance().requestManaExact(stack, player, props.maxMana, false)) {
            burst.setColor(props.color);
            burst.setMana(props.maxMana);
            burst.setStartingMana(props.maxMana);
            burst.setMinManaLoss(props.ticksBeforeManaLoss);
            burst.setManaLossPerTick(props.manaLossPerTick);
            burst.setGravity(props.gravity);
            burst.setBurstMotion(burst.func_213322_ci().func_82615_a() * (double)props.motionModifier, burst.func_213322_ci().func_82617_b() * (double)props.motionModifier, burst.func_213322_ci().func_82616_c() * (double)props.motionModifier);
            return burst;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        List lensTip;
        boolean clip = ItemManaGun.hasClip(stack);
        if (clip && !Screen.func_231173_s_()) {
            tooltip.add(TooltipHandler.getShiftInfoTooltip());
            return;
        }
        ItemStack lens = ItemManaGun.getLens(stack);
        if (!lens.func_190926_b() && (lensTip = lens.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL)).size() > 1) {
            tooltip.addAll(lensTip.subList(1, lensTip.size()));
        }
        if (clip) {
            int pos = ItemManaGun.getClipPos(stack);
            tooltip.add((ITextComponent)new TranslationTextComponent("botaniamisc.hasClip"));
            for (int i = 0; i < 6; ++i) {
                ItemStack lensAt = ItemManaGun.getLensAtPos(stack, i);
                Object name = lensAt.func_190926_b() ? new TranslationTextComponent("botaniamisc.clipEmpty") : lensAt.func_200301_q();
                IFormattableTextComponent tip = new StringTextComponent(" - ").func_230529_a_(name);
                tip.func_240699_a_(i == pos ? TextFormatting.GREEN : TextFormatting.GRAY);
                tooltip.add((ITextComponent)tip);
            }
        }
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        ItemStack lens = ItemManaGun.getLens(stack);
        IFormattableTextComponent cmp = super.func_200295_i(stack).func_230532_e_();
        if (!lens.func_190926_b()) {
            cmp.func_240702_b_(" (");
            cmp.func_230529_a_((ITextComponent)lens.func_200301_q().func_230532_e_().func_240699_a_(TextFormatting.GREEN));
            cmp.func_240702_b_(")");
        }
        return cmp;
    }

    public static boolean hasClip(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_CLIP, false);
    }

    public static void setClip(ItemStack stack, boolean clip) {
        ItemNBTHelper.setBoolean(stack, TAG_CLIP, clip);
    }

    public static int getClipPos(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_CLIP_POS, 0);
    }

    public static void setClipPos(ItemStack stack, int pos) {
        ItemNBTHelper.setInt(stack, TAG_CLIP_POS, pos);
    }

    public static void rotatePos(ItemStack stack) {
        int currPos = ItemManaGun.getClipPos(stack);
        boolean acceptEmpty = !ItemManaGun.getLensAtPos(stack, currPos).func_190926_b();
        int[] slots = new int[5];
        int index = 0;
        int i = currPos + 1;
        while (i < 6) {
            slots[index] = i++;
            ++index;
        }
        i = 0;
        while (i < currPos) {
            slots[index] = i++;
            ++index;
        }
        for (int i2 : slots) {
            ItemStack lensAt = ItemManaGun.getLensAtPos(stack, i2);
            if (!acceptEmpty && lensAt.func_190926_b()) continue;
            ItemManaGun.setClipPos(stack, i2);
            return;
        }
    }

    public static ItemStack getLensAtPos(ItemStack stack, int pos) {
        CompoundNBT cmp = ItemNBTHelper.getCompound(stack, TAG_LENS + pos, true);
        if (cmp != null) {
            return ItemStack.func_199557_a((CompoundNBT)cmp);
        }
        return ItemStack.field_190927_a;
    }

    public static void setLensAtPos(ItemStack stack, ItemStack lens, int pos) {
        CompoundNBT cmp = new CompoundNBT();
        if (lens != null) {
            cmp = lens.func_77955_b(cmp);
        }
        ItemNBTHelper.setCompound(stack, TAG_LENS + pos, cmp);
    }

    public static void setLens(ItemStack stack, ItemStack lens) {
        if (ItemManaGun.hasClip(stack)) {
            ItemManaGun.setLensAtPos(stack, lens, ItemManaGun.getClipPos(stack));
        }
        CompoundNBT cmp = new CompoundNBT();
        if (!lens.func_190926_b()) {
            cmp = lens.func_77955_b(cmp);
        }
        ItemNBTHelper.setCompound(stack, TAG_LENS, cmp);
    }

    public static ItemStack getLens(ItemStack stack) {
        if (ItemManaGun.hasClip(stack)) {
            return ItemManaGun.getLensAtPos(stack, ItemManaGun.getClipPos(stack));
        }
        CompoundNBT cmp = ItemNBTHelper.getCompound(stack, TAG_LENS, true);
        if (cmp != null) {
            return ItemStack.func_199557_a((CompoundNBT)cmp);
        }
        return ItemStack.field_190927_a;
    }

    public static List<ItemStack> getAllLens(ItemStack stack) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int i = 0; i < 6; ++i) {
            ret.add(ItemManaGun.getLensAtPos(stack, i));
        }
        return ret;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (this.getCooldown(stack) > 0) {
            this.setCooldown(stack, this.getCooldown(stack) - 1);
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getCooldown(stack) > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)this.getCooldown(stack) / 30.0;
    }

    private int getCooldown(ItemStack stack) {
        return stack.func_196082_o().func_74762_e(TAG_COOLDOWN);
    }

    private void setCooldown(ItemStack stack, int cooldown) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74768_a(TAG_COOLDOWN, cooldown);
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }
}

