/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.block;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.lib.ModTags;

public class ItemBlockSpecialFlower
extends BlockItem {
    private static final ITag.INamedTag<Item> GENERATING = ModTags.Items.GENERATING_SPECIAL_FLOWERS;
    private static final ITag.INamedTag<Item> FUNCTIONAL = ModTags.Items.FUNCTIONAL_SPECIAL_FLOWERS;
    private static final ITag.INamedTag<Item> MISC = ModTags.Items.MISC_SPECIAL_FLOWERS;

    public ItemBlockSpecialFlower(Block block1, Item.Properties props) {
        super(block1, props);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        if (Botania.configLoaded) {
            String key;
            TranslationTextComponent lore;
            if (world != null) {
                if (GENERATING.func_230235_a_((Object)this)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("botania.flowerType.generating").func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.BLUE}));
                } else if (FUNCTIONAL.func_230235_a_((Object)this)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("botania.flowerType.functional").func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.BLUE}));
                } else if (MISC.func_230235_a_((Object)this)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("botania.flowerType.misc").func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.BLUE}));
                }
            }
            if (((Boolean)ConfigHandler.CLIENT.referencesEnabled.get()).booleanValue() && !(lore = new TranslationTextComponent(key = this.func_77658_a() + ".reference")).getString().equals(key)) {
                tooltip.add((ITextComponent)lore.func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GRAY}));
            }
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        CompoundNBT tag = stack.func_179543_a("BlockEntityTag");
        return tag != null && tag.func_74764_b("passiveDecayTicks");
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        CompoundNBT tag = stack.func_179543_a("BlockEntityTag");
        if (tag != null) {
            return (double)tag.func_74762_e("passiveDecayTicks") / (double)BotaniaAPI.instance().getPassiveFlowerDecay();
        }
        return 0.0;
    }
}

