/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.wand.ICoordBoundItem;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.item.relic.ItemRelic;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.botania.common.network.PacketHandler;

public class ItemFlugelEye
extends ItemRelic
implements ICoordBoundItem,
IManaUsingItem {
    private static final String TAG_TARGET_PREFIX = "target_";

    public ItemFlugelEye(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        PlayerEntity player = ctx.func_195999_j();
        if (player != null && player.func_225608_bj_()) {
            if (world.field_72995_K) {
                for (int i = 0; i < 10; ++i) {
                    float x1 = (float)((double)pos.func_177958_n() + Math.random());
                    float y1 = pos.func_177956_o() + 1;
                    float z1 = (float)((double)pos.func_177952_p() + Math.random());
                    WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.5f, (float)Math.random(), (float)Math.random(), (float)Math.random(), 1.0f);
                    world.func_195594_a((IParticleData)data, (double)x1, (double)y1, (double)z1, 0.0, (double)(0.05f - (float)Math.random() * 0.05f), 0.0);
                }
            } else {
                ItemStack stack = ctx.func_195996_i();
                INBT nbt = (INBT)BlockPos.field_239578_a_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)pos).get().orThrow();
                ItemNBTHelper.set(stack, TAG_TARGET_PREFIX + world.func_234923_W_().func_240901_a_().toString(), nbt);
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 5.0f);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_219972_a(World world, LivingEntity living, ItemStack stack, int count) {
        if (world.field_72995_K) {
            float x = (float)(living.func_226277_ct_() - Math.random() * (double)living.func_213311_cf());
            float y = (float)(living.func_226278_cu_() + Math.random());
            float z = (float)(living.func_226281_cx_() - Math.random() * (double)living.func_213311_cf());
            WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.7f, (float)Math.random(), (float)Math.random(), (float)Math.random(), 1.0f);
            world.func_195594_a((IParticleData)data, (double)x, (double)y, (double)z, 0.0, (double)(0.05f + (float)Math.random() * 0.05f), 0.0);
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        player.func_184598_c(hand);
        return ActionResult.func_226249_b_((Object)player.func_184586_b(hand));
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, World world, LivingEntity living) {
        String tag = TAG_TARGET_PREFIX + world.func_234923_W_().func_240901_a_().toString();
        INBT nbt = ItemNBTHelper.get(stack, tag);
        if (nbt == null) {
            return stack;
        }
        Optional maybeLoc = BlockPos.field_239578_a_.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)nbt).result();
        if (!maybeLoc.isPresent()) {
            ItemNBTHelper.removeEntry(stack, tag);
            return stack;
        }
        BlockPos loc = (BlockPos)maybeLoc.get();
        int x = loc.func_177958_n();
        int y = loc.func_177956_o();
        int z = loc.func_177952_p();
        int cost = (int)(MathHelper.pointDistanceSpace((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_()) * 10.0f);
        if (!(living instanceof PlayerEntity) || ManaItemHandler.instance().requestManaExact(stack, (PlayerEntity)living, cost, true)) {
            ItemFlugelEye.moveParticlesAndSound((Entity)living);
            living.func_70634_a((double)x + 0.5, (double)y + 1.5, (double)z + 0.5);
            ItemFlugelEye.moveParticlesAndSound((Entity)living);
        }
        return stack;
    }

    private static void moveParticlesAndSound(Entity entity) {
        PacketHandler.sendToNearby(entity.field_70170_p, entity, (Object)new PacketBotaniaEffect(PacketBotaniaEffect.EffectType.FLUGEL_EFFECT, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.func_145782_y()));
        entity.field_70170_p.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    public int func_77626_a(ItemStack stack) {
        return 40;
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    @Override
    @Nullable
    public BlockPos getBinding(World world, ItemStack stack) {
        String tag = TAG_TARGET_PREFIX + world.func_234923_W_().func_240901_a_().toString();
        INBT nbt = ItemNBTHelper.get(stack, tag);
        if (nbt != null) {
            return BlockPos.field_239578_a_.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)nbt).result().orElse(null);
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        super.func_77624_a(stack, world, tooltip, flags);
        if (world == null) {
            return;
        }
        BlockPos binding = this.getBinding(world, stack);
        IFormattableTextComponent worldText = new StringTextComponent(world.func_234923_W_().func_240901_a_().toString()).func_240699_a_(TextFormatting.GREEN);
        if (binding == null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("botaniamisc.flugelUnbound", new Object[]{worldText}).func_240699_a_(TextFormatting.GRAY));
        } else {
            IFormattableTextComponent bindingText = new StringTextComponent("[").func_240699_a_(TextFormatting.WHITE).func_230529_a_((ITextComponent)new StringTextComponent(Integer.toString(binding.func_177958_n())).func_240699_a_(TextFormatting.GOLD)).func_240702_b_(", ").func_230529_a_((ITextComponent)new StringTextComponent(Integer.toString(binding.func_177956_o())).func_240699_a_(TextFormatting.GOLD)).func_240702_b_(", ").func_230529_a_((ITextComponent)new StringTextComponent(Integer.toString(binding.func_177952_p())).func_240699_a_(TextFormatting.GOLD)).func_240702_b_("]");
            tooltip.add((ITextComponent)new TranslationTextComponent("botaniamisc.flugelBound", new Object[]{bindingText, worldText}).func_240699_a_(TextFormatting.GRAY));
        }
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public ResourceLocation getAdvancement() {
        return ResourceLocationHelper.prefix("challenge/flugel_eye");
    }
}

