/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.network;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.OrechidOutput;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.Botania;
import vazkii.botania.common.crafting.StateIngredientHelper;
import vazkii.botania.common.impl.BotaniaAPIImpl;

public class PacketOrechidData {
    private final List<OrechidOutput> normal;
    private final List<OrechidOutput> nether;

    private PacketOrechidData(List<OrechidOutput> normal, List<OrechidOutput> nether) {
        this.normal = normal;
        this.nether = nether;
    }

    public static PacketOrechidData create() {
        return new PacketOrechidData(BotaniaAPI.instance().getOrechidWeights(), BotaniaAPI.instance().getNetherOrechidWeights());
    }

    public void encode(PacketBuffer buf) {
        buf.func_150787_b(this.normal.size());
        for (OrechidOutput output : this.normal) {
            output.getOutput().write(buf);
            buf.func_150787_b(output.getWeight());
        }
        buf.func_150787_b(this.nether.size());
        for (OrechidOutput output : this.nether) {
            output.getOutput().write(buf);
            buf.func_150787_b(output.getWeight());
        }
    }

    public static PacketOrechidData decode(PacketBuffer buf) {
        int count = buf.func_150792_a();
        List<OrechidOutput> normal = Stream.generate(() -> {
            StateIngredient ingr = StateIngredientHelper.read(buf);
            int weight = buf.func_150792_a();
            return new OrechidOutput(weight, ingr);
        }).limit(count).collect(Collectors.toList());
        count = buf.func_150792_a();
        List<OrechidOutput> nether = Stream.generate(() -> {
            StateIngredient ingr = StateIngredientHelper.read(buf);
            int weight = buf.func_150792_a();
            return new OrechidOutput(weight, ingr);
        }).limit(count).collect(Collectors.toList());
        return new PacketOrechidData(normal, nether);
    }

    public static void handle(PacketOrechidData msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> {
                Botania.LOGGER.debug("Received orechid data with {} standard and {} nether results", (Object)msg.normal.size(), (Object)msg.nether.size());
                BotaniaAPIImpl.weights = msg.normal;
                BotaniaAPIImpl.netherWeights = msg.nether;
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

