/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.Botania;
import vazkii.botania.common.crafting.StateIngredientHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class OrechidProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public OrechidProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.registerMaps((map, loc) -> {
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)this.convertMapToJson((Object2IntMap<StateIngredient>)map), (Path)OrechidProvider.getPath(this.generator.func_200391_b(), ResourceLocationHelper.prefix(loc)));
            }
            catch (IOException e) {
                Botania.LOGGER.error("Exception writing file", (Throwable)e);
            }
        });
    }

    protected void registerMaps(BiConsumer<Object2IntMap<StateIngredient>, String> consumer) {
        consumer.accept(this.orechidMap(), "orechid");
        consumer.accept(this.netherOrechidMap(), "orechid_ignem");
    }

    protected JsonObject convertMapToJson(Object2IntMap<StateIngredient> map) {
        JsonObject o = new JsonObject();
        JsonArray weights = map.object2IntEntrySet().stream().map(entry -> {
            JsonObject serialized = ((StateIngredient)entry.getKey()).serialize();
            serialized.addProperty("weight", (Number)entry.getIntValue());
            return serialized;
        }).collect(JsonArray::new, JsonArray::add, JsonArray::addAll);
        o.add("values", (JsonElement)weights);
        return o;
    }

    protected Object2IntMap<StateIngredient> orechidMap() {
        Object2IntArrayMap map = new Object2IntArrayMap();
        map.put((Object)OrechidProvider.forBlock(Blocks.field_150365_q), 67415);
        map.put((Object)OrechidProvider.forBlock(Blocks.field_150366_p), 29371);
        map.put((Object)OrechidProvider.forBlock(Blocks.field_150450_ax), 7654);
        map.put((Object)OrechidProvider.forBlock(Blocks.field_150352_o), 2647);
        map.put((Object)OrechidProvider.forBlock(Blocks.field_150412_bA), 1239);
        map.put((Object)OrechidProvider.forBlock(Blocks.field_150369_x), 1079);
        map.put((Object)OrechidProvider.forBlock(Blocks.field_150482_ag), 883);
        map.put((Object)OrechidProvider.forOreTag("aluminium"), 13762);
        map.put((Object)OrechidProvider.forOreTag("aluminum"), 13762);
        map.put((Object)OrechidProvider.forOreTag("copper"), 5567);
        map.put((Object)OrechidProvider.forOreTag("ferrous"), 558);
        map.put((Object)OrechidProvider.forOreTag("galena"), 4096);
        map.put((Object)OrechidProvider.forOreTag("lead"), 4093);
        map.put((Object)OrechidProvider.forOreTag("mithril"), 6485);
        map.put((Object)OrechidProvider.forOreTag("mythril"), 6485);
        map.put((Object)OrechidProvider.forOreTag("nickel"), 2275);
        map.put((Object)OrechidProvider.forOreTag("osmium"), 6915);
        map.put((Object)OrechidProvider.forOreTag("platinum"), 956);
        map.put((Object)OrechidProvider.forOreTag("silver"), 4315);
        map.put((Object)OrechidProvider.forOreTag("tin"), 8251);
        map.put((Object)OrechidProvider.forOreTag("tungsten"), 140);
        map.put((Object)OrechidProvider.forOreTag("uranium"), 230);
        map.put((Object)OrechidProvider.forOreTag("zinc"), 838);
        map.put((Object)OrechidProvider.forOreTag("amber"), 902);
        map.put((Object)OrechidProvider.forOreTag("ruby"), 1384);
        map.put((Object)OrechidProvider.forOreTag("sapphire"), 1287);
        map.put((Object)OrechidProvider.forOreTag("topaz"), 6436);
        map.put((Object)OrechidProvider.forOreTag("amethyst"), 1307);
        map.put((Object)OrechidProvider.forOreTag("malachite"), 160);
        map.put((Object)OrechidProvider.forOreTag("yellorite"), 3520);
        map.put((Object)OrechidProvider.forOreTag("teslatite"), 4312);
        map.put((Object)OrechidProvider.forOreTag("dark"), 1350);
        map.put((Object)OrechidProvider.forOreTag("apatite"), 250);
        map.put((Object)OrechidProvider.forOreTag("inferium"), 10000);
        map.put((Object)OrechidProvider.forOreTag("prosperity"), 7420);
        map.put((Object)OrechidProvider.forOreTag("olivine"), 1100);
        map.put((Object)OrechidProvider.forOreTag("sulfur"), 1105);
        map.put((Object)OrechidProvider.forOreTag("sulphur"), 1105);
        map.put((Object)OrechidProvider.forOreTag("adamantium"), 1469);
        map.put((Object)OrechidProvider.forOreTag("bismuth"), 2407);
        map.put((Object)OrechidProvider.forOreTag("cinnabar"), 2585);
        return map;
    }

    protected Object2IntMap<StateIngredient> netherOrechidMap() {
        Object2IntArrayMap map = new Object2IntArrayMap();
        map.put((Object)OrechidProvider.forBlock(Blocks.field_196766_fg), 19600);
        map.put((Object)OrechidProvider.forBlock(Blocks.field_235334_I_), 3635);
        map.put((Object)OrechidProvider.forBlock(Blocks.field_235398_nh_), 148);
        map.put((Object)OrechidProvider.forOreTag("nether/inferium"), 10000);
        map.put((Object)OrechidProvider.forOreTag("nether/prosperity"), 7420);
        map.put((Object)OrechidProvider.forOreTag("nether/coal"), 17000);
        map.put((Object)OrechidProvider.forOreTag("nether/copper"), 4700);
        map.put((Object)OrechidProvider.forOreTag("nether/diamond"), 175);
        map.put((Object)OrechidProvider.forOreTag("nether/iron"), 5790);
        map.put((Object)OrechidProvider.forOreTag("nether/lapis"), 3250);
        map.put((Object)OrechidProvider.forOreTag("nether/lead"), 2790);
        map.put((Object)OrechidProvider.forOreTag("nether/nickel"), 1790);
        map.put((Object)OrechidProvider.forOreTag("nether/platinum"), 170);
        map.put((Object)OrechidProvider.forOreTag("nether/redstone"), 5600);
        map.put((Object)OrechidProvider.forOreTag("nether/silver"), 1550);
        map.put((Object)OrechidProvider.forOreTag("nether/steel"), 1690);
        map.put((Object)OrechidProvider.forOreTag("nether/tin"), 3750);
        map.put((Object)OrechidProvider.forOreTag("argonite"), 1000);
        map.put((Object)OrechidProvider.forOreTag("ashstone"), 1000);
        map.put((Object)OrechidProvider.forOreTag("dragonstone"), 175);
        map.put((Object)OrechidProvider.forOreTag("fyrite"), 1000);
        map.put((Object)OrechidProvider.forOreTag("firestone"), 5);
        map.put((Object)OrechidProvider.forOreTag("onyx"), 500);
        map.put((Object)OrechidProvider.forOreTag("ardite"), 500);
        map.put((Object)OrechidProvider.forOreTag("cobalt"), 500);
        return map;
    }

    private static Path getPath(Path root, ResourceLocation id) {
        return root.resolve("data/" + id.func_110624_b() + "/orechid_ore_weights/" + id.func_110623_a() + ".json");
    }

    protected static StateIngredient forOreTag(String oreTag) {
        return StateIngredientHelper.of(new ResourceLocation("forge", "ores/" + oreTag));
    }

    protected static StateIngredient forBlock(Block block) {
        return StateIngredientHelper.of(block);
    }

    public String func_200397_b() {
        return "Botania Orechid weight data";
    }
}

