/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.client.render.TurtleModelLoader;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.media.items.ItemDisk;
import dan200.computercraft.shared.media.items.ItemTreasureDisk;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import dan200.computercraft.shared.util.Colour;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.SimpleModelTransform;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="computercraft", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ClientRegistry {
    private static final String[] EXTRA_MODELS = new String[]{"turtle_modem_normal_off_left", "turtle_modem_normal_on_left", "turtle_modem_normal_off_right", "turtle_modem_normal_on_right", "turtle_modem_advanced_off_left", "turtle_modem_advanced_on_left", "turtle_modem_advanced_off_right", "turtle_modem_advanced_on_right", "turtle_crafting_table_left", "turtle_crafting_table_right", "turtle_speaker_upgrade_left", "turtle_speaker_upgrade_right", "turtle_colour", "turtle_elf_overlay"};
    private static final String[] EXTRA_TEXTURES = new String[]{"block/turtle_colour", "block/turtle_elf_overlay", "block/turtle_crafty_face", "block/turtle_speaker_face"};

    private ClientRegistry() {
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("computercraft", "turtle"), (IModelLoader)TurtleModelLoader.INSTANCE);
    }

    @SubscribeEvent
    public static void onTextureStitchEvent(TextureStitchEvent.Pre event) {
        if (!event.getMap().func_229223_g_().equals((Object)PlayerContainer.field_226615_c_)) {
            return;
        }
        for (String extra : EXTRA_TEXTURES) {
            event.addSprite(new ResourceLocation("computercraft", extra));
        }
    }

    @SubscribeEvent
    public static void onModelBakeEvent(ModelBakeEvent event) {
        ModelLoader loader = event.getModelLoader();
        Map registry = event.getModelRegistry();
        for (String modelName : EXTRA_MODELS) {
            ResourceLocation location = new ResourceLocation("computercraft", "item/" + modelName);
            IUnbakedModel model = loader.func_209597_a(location);
            model.func_225614_a_(arg_0 -> ((ModelLoader)loader).func_209597_a(arg_0), new HashSet());
            IBakedModel baked = model.func_225613_a_((ModelBakery)loader, ModelLoader.defaultTextureGetter(), (IModelTransform)SimpleModelTransform.IDENTITY, location);
            if (baked == null) continue;
            registry.put(new ModelResourceLocation(new ResourceLocation("computercraft", modelName), "inventory"), baked);
        }
    }

    @SubscribeEvent
    public static void onItemColours(ColorHandlerEvent.Item event) {
        if (Registry.ModItems.DISK == null || Registry.ModBlocks.TURTLE_NORMAL == null) {
            ComputerCraft.log.warn("Block/item registration has failed. Skipping registration of item colours.");
            return;
        }
        event.getItemColors().func_199877_a((stack, layer) -> layer == 1 ? ((ItemDisk)stack.func_77973_b()).getColour(stack) : 0xFFFFFF, new IItemProvider[]{(IItemProvider)Registry.ModItems.DISK.get()});
        event.getItemColors().func_199877_a((stack, layer) -> layer == 1 ? ItemTreasureDisk.getColour(stack) : 0xFFFFFF, new IItemProvider[]{(IItemProvider)Registry.ModItems.TREASURE_DISK.get()});
        event.getItemColors().func_199877_a((stack, layer) -> {
            switch (layer) {
                default: {
                    return 0xFFFFFF;
                }
                case 1: {
                    return IColouredItem.getColourBasic(stack);
                }
                case 2: 
            }
            int light = ItemPocketComputer.getLightState(stack);
            return light == -1 ? Colour.BLACK.getHex() : light;
        }, new IItemProvider[]{(IItemProvider)Registry.ModItems.POCKET_COMPUTER_NORMAL.get(), (IItemProvider)Registry.ModItems.POCKET_COMPUTER_ADVANCED.get()});
        event.getItemColors().func_199877_a((stack, tintIndex) -> tintIndex == 0 ? ((IColouredItem)stack.func_77973_b()).getColour(stack) : 0xFFFFFF, new IItemProvider[]{(IItemProvider)Registry.ModBlocks.TURTLE_NORMAL.get(), (IItemProvider)Registry.ModBlocks.TURTLE_ADVANCED.get()});
    }
}

