/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.client.gui.widgets.WidgetTerminal;
import dan200.computercraft.client.gui.widgets.WidgetWrapper;
import dan200.computercraft.client.render.ComputerBorderRenderer;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.inventory.ContainerComputer;
import dan200.computercraft.shared.computer.inventory.ContainerComputerBase;
import dan200.computercraft.shared.computer.inventory.ContainerViewComputer;
import dan200.computercraft.shared.pocket.inventory.ContainerPocketComputer;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public final class GuiComputer<T extends ContainerComputerBase>
extends ContainerScreen<T> {
    private final ComputerFamily family;
    private final ClientComputer computer;
    private final int termWidth;
    private final int termHeight;
    private WidgetTerminal terminal;
    private WidgetWrapper terminalWrapper;

    private GuiComputer(T container, PlayerInventory player, ITextComponent title, int termWidth, int termHeight) {
        super(container, player, title);
        this.family = ((ContainerComputerBase)container).getFamily();
        this.computer = (ClientComputer)((ContainerComputerBase)container).getComputer();
        this.termWidth = termWidth;
        this.termHeight = termHeight;
        this.terminal = null;
    }

    public static GuiComputer<ContainerComputer> create(ContainerComputer container, PlayerInventory inventory, ITextComponent component) {
        return new GuiComputer<ContainerComputer>(container, inventory, component, ComputerCraft.computerTermWidth, ComputerCraft.computerTermHeight);
    }

    public static GuiComputer<ContainerPocketComputer> createPocket(ContainerPocketComputer container, PlayerInventory inventory, ITextComponent component) {
        return new GuiComputer<ContainerPocketComputer>(container, inventory, component, ComputerCraft.pocketTermWidth, ComputerCraft.pocketTermHeight);
    }

    public static GuiComputer<ContainerViewComputer> createView(ContainerViewComputer container, PlayerInventory inventory, ITextComponent component) {
        return new GuiComputer<ContainerViewComputer>(container, inventory, component, container.getWidth(), container.getHeight());
    }

    protected void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        int termPxWidth = this.termWidth * 6;
        int termPxHeight = this.termHeight * 9;
        this.field_146999_f = termPxWidth + 4 + 24;
        this.field_147000_g = termPxHeight + 4 + 24;
        super.func_231160_c_();
        this.terminal = new WidgetTerminal(this.field_230706_i_, () -> this.computer, this.termWidth, this.termHeight, 2, 2, 2, 2);
        this.terminalWrapper = new WidgetWrapper(this.terminal, 14 + this.field_147003_i, 14 + this.field_147009_r, termPxWidth, termPxHeight);
        this.field_230705_e_.add(this.terminalWrapper);
        this.func_231035_a_(this.terminalWrapper);
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.field_230705_e_.remove(this.terminal);
        this.terminal = null;
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.terminal.update();
    }

    public boolean func_231046_a_(int key, int scancode, int modifiers) {
        if (key == 258 && this.func_241217_q_() != null && this.func_241217_q_() == this.terminalWrapper) {
            return this.func_241217_q_().func_231046_a_(key, scancode, modifiers);
        }
        return super.func_231046_a_(key, scancode, modifiers);
    }

    public void func_230450_a_(@Nonnull MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        this.terminal.draw(this.terminalWrapper.getX(), this.terminalWrapper.getY());
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(ComputerBorderRenderer.getTexture(this.family));
        ComputerBorderRenderer.render(this.terminalWrapper.getX() - 2, this.terminalWrapper.getY() - 2, this.func_230927_p_(), this.terminalWrapper.getWidth() + 4, this.terminalWrapper.getHeight() + 4);
    }

    public void func_230430_a_(@Nonnull MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(stack, mouseX, mouseY);
    }

    public boolean func_231045_a_(double x, double y, int button, double deltaX, double deltaY) {
        return this.func_241217_q_() != null && this.func_241217_q_().func_231045_a_(x, y, button, deltaX, deltaY) || super.func_231045_a_(x, y, button, deltaX, deltaY);
    }

    protected void func_230451_b_(@Nonnull MatrixStack transform, int mouseX, int mouseY) {
    }
}

