/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.proxy;

import dan200.computercraft.client.gui.GuiComputer;
import dan200.computercraft.client.gui.GuiDiskDrive;
import dan200.computercraft.client.gui.GuiPrinter;
import dan200.computercraft.client.gui.GuiPrintout;
import dan200.computercraft.client.gui.GuiTurtle;
import dan200.computercraft.client.render.TileEntityMonitorRenderer;
import dan200.computercraft.client.render.TileEntityTurtleRenderer;
import dan200.computercraft.client.render.TurtlePlayerRenderer;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.peripheral.monitor.ClientMonitor;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="computercraft", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ComputerCraftProxyClient {
    @SubscribeEvent
    public static void setupClient(FMLClientSetupEvent event) {
        ComputerCraftProxyClient.registerContainers();
        RenderTypeLookup.setRenderLayer((Block)((Block)Registry.ModBlocks.TURTLE_NORMAL.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)((Block)Registry.ModBlocks.TURTLE_ADVANCED.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)((Block)Registry.ModBlocks.MONITOR_NORMAL.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)Registry.ModBlocks.MONITOR_ADVANCED.get()), (RenderType)RenderType.func_228643_e_());
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)Registry.ModTiles.MONITOR_NORMAL.get()), TileEntityMonitorRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)Registry.ModTiles.MONITOR_ADVANCED.get()), TileEntityMonitorRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)Registry.ModTiles.TURTLE_NORMAL.get()), TileEntityTurtleRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)Registry.ModTiles.TURTLE_ADVANCED.get()), TileEntityTurtleRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)Registry.ModEntities.TURTLE_PLAYER.get()), TurtlePlayerRenderer::new);
        ComputerCraftProxyClient.registerItemProperty("state", (stack, world, player) -> ItemPocketComputer.getState(stack).ordinal(), new Supplier[]{Registry.ModItems.POCKET_COMPUTER_NORMAL, Registry.ModItems.POCKET_COMPUTER_ADVANCED});
        ComputerCraftProxyClient.registerItemProperty("state", (stack, world, player) -> IColouredItem.getColourBasic(stack) != -1 ? 1.0f : 0.0f, new Supplier[]{Registry.ModItems.POCKET_COMPUTER_NORMAL, Registry.ModItems.POCKET_COMPUTER_ADVANCED});
    }

    @SafeVarargs
    private static void registerItemProperty(String name, IItemPropertyGetter getter, Supplier<? extends Item> ... items) {
        ResourceLocation id = new ResourceLocation("computercraft", name);
        for (Supplier<? extends Item> item : items) {
            ItemModelsProperties.func_239418_a_((Item)item.get(), (ResourceLocation)id, (IItemPropertyGetter)getter);
        }
    }

    private static void registerContainers() {
        ScreenManager.func_216911_a((ContainerType)((ContainerType)Registry.ModContainers.COMPUTER.get()), GuiComputer::create);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)Registry.ModContainers.POCKET_COMPUTER.get()), GuiComputer::createPocket);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)Registry.ModContainers.TURTLE.get()), GuiTurtle::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)Registry.ModContainers.PRINTER.get()), GuiPrinter::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)Registry.ModContainers.DISK_DRIVE.get()), GuiDiskDrive::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)Registry.ModContainers.PRINTOUT.get()), GuiPrintout::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)Registry.ModContainers.VIEW_COMPUTER.get()), GuiComputer::createView);
    }

    @Mod.EventBusSubscriber(modid="computercraft", value={Dist.CLIENT})
    public static final class ForgeHandlers {
        @SubscribeEvent
        public static void onWorldUnload(WorldEvent.Unload event) {
            if (event.getWorld().func_201670_d()) {
                ClientMonitor.destroyAll();
            }
        }
    }
}

