/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.apis.TableHelper;
import dan200.computercraft.core.apis.http.CheckUrl;
import dan200.computercraft.core.apis.http.HTTPRequestException;
import dan200.computercraft.core.apis.http.Resource;
import dan200.computercraft.core.apis.http.ResourceGroup;
import dan200.computercraft.core.apis.http.ResourceQueue;
import dan200.computercraft.core.apis.http.request.HttpRequest;
import dan200.computercraft.core.apis.http.websocket.Websocket;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.net.URI;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;

public class HTTPAPI
implements ILuaAPI {
    private final IAPIEnvironment apiEnvironment;
    private final ResourceGroup<CheckUrl> checkUrls = new ResourceGroup();
    private final ResourceGroup<HttpRequest> requests = new ResourceQueue<HttpRequest>(() -> ComputerCraft.httpMaxRequests);
    private final ResourceGroup<Websocket> websockets = new ResourceGroup(() -> ComputerCraft.httpMaxWebsockets);

    public HTTPAPI(IAPIEnvironment environment) {
        this.apiEnvironment = environment;
    }

    @Override
    public String[] getNames() {
        return new String[]{"http"};
    }

    @Override
    public void startup() {
        this.checkUrls.startup();
        this.requests.startup();
        this.websockets.startup();
    }

    @Override
    public void shutdown() {
        this.checkUrls.shutdown();
        this.requests.shutdown();
        this.websockets.shutdown();
    }

    @Override
    public void update() {
        Resource.cleanup();
    }

    @LuaFunction
    public final Object[] request(IArguments args) throws LuaException {
        HttpMethod httpMethod;
        boolean redirect;
        String requestMethod;
        boolean binary;
        Map<Object, Object> headerTable;
        String postString;
        String address;
        if (args.get(0) instanceof Map) {
            Map<?, ?> options = args.getTable(0);
            address = TableHelper.getStringField(options, "url");
            postString = TableHelper.optStringField(options, "body", null);
            headerTable = TableHelper.optTableField(options, "headers", Collections.emptyMap());
            binary = TableHelper.optBooleanField(options, "binary", false);
            requestMethod = TableHelper.optStringField(options, "method", null);
            redirect = TableHelper.optBooleanField(options, "redirect", true);
        } else {
            address = args.getString(0);
            postString = args.optString(1, null);
            headerTable = args.optTable(2, Collections.emptyMap());
            binary = args.optBoolean(3, false);
            requestMethod = null;
            redirect = true;
        }
        HttpHeaders headers = this.getHeaders(headerTable);
        if (requestMethod == null) {
            httpMethod = postString == null ? HttpMethod.GET : HttpMethod.POST;
        } else {
            httpMethod = HttpMethod.valueOf((String)requestMethod.toUpperCase(Locale.ROOT));
            if (httpMethod == null || requestMethod.equalsIgnoreCase("CONNECT")) {
                throw new LuaException("Unsupported HTTP method");
            }
        }
        try {
            URI uri = HttpRequest.checkUri(address);
            HttpRequest request = new HttpRequest(this.requests, this.apiEnvironment, address, postString, headers, binary, redirect);
            request.queue(r -> r.request(uri, httpMethod));
            return new Object[]{true};
        }
        catch (HTTPRequestException e) {
            return new Object[]{false, e.getMessage()};
        }
    }

    @LuaFunction
    public final Object[] checkURL(String address) {
        try {
            URI uri = HttpRequest.checkUri(address);
            new CheckUrl(this.checkUrls, this.apiEnvironment, address, uri).queue(CheckUrl::run);
            return new Object[]{true};
        }
        catch (HTTPRequestException e) {
            return new Object[]{false, e.getMessage()};
        }
    }

    @LuaFunction
    public final Object[] websocket(String address, Optional<Map<?, ?>> headerTbl) throws LuaException {
        if (!ComputerCraft.httpWebsocketEnabled) {
            throw new LuaException("Websocket connections are disabled");
        }
        HttpHeaders headers = this.getHeaders(headerTbl.orElse(Collections.emptyMap()));
        try {
            URI uri = Websocket.checkUri(address);
            if (!new Websocket(this.websockets, this.apiEnvironment, uri, address, headers).queue(Websocket::connect)) {
                throw new LuaException("Too many websockets already open");
            }
            return new Object[]{true};
        }
        catch (HTTPRequestException e) {
            return new Object[]{false, e.getMessage()};
        }
    }

    @Nonnull
    private HttpHeaders getHeaders(@Nonnull Map<?, ?> headerTable) throws LuaException {
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        for (Map.Entry<?, ?> entry : headerTable.entrySet()) {
            Object value = entry.getValue();
            if (!(entry.getKey() instanceof String) || !(value instanceof String)) continue;
            try {
                headers.add((String)entry.getKey(), value);
            }
            catch (IllegalArgumentException e) {
                throw new LuaException(e.getMessage());
            }
        }
        if (!headers.contains((CharSequence)HttpHeaderNames.USER_AGENT)) {
            headers.set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)this.apiEnvironment.getComputerEnvironment().getUserAgent());
        }
        return headers;
    }
}

