/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.http;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.core.apis.http.HTTPRequestException;
import dan200.computercraft.core.apis.http.options.Action;
import dan200.computercraft.core.apis.http.options.AddressRule;
import dan200.computercraft.core.apis.http.options.Options;
import dan200.computercraft.shared.util.ThreadUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.KeyStore;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;

public final class NetworkUtils {
    public static final ExecutorService EXECUTOR = new ThreadPoolExecutor(4, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), ThreadUtils.builder("Network").setPriority(3).build());
    public static final EventLoopGroup LOOP_GROUP = new NioEventLoopGroup(4, ThreadUtils.builder("Netty").setPriority(3).build());
    private static final Object sslLock = new Object();
    private static TrustManagerFactory trustManager;
    private static SslContext sslContext;
    private static boolean triedSslContext;

    private NetworkUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TrustManagerFactory getTrustManager() {
        if (trustManager != null) {
            return trustManager;
        }
        Object object = sslLock;
        synchronized (object) {
            if (trustManager != null) {
                return trustManager;
            }
            TrustManagerFactory tmf = null;
            try {
                tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init((KeyStore)null);
            }
            catch (Exception e) {
                ComputerCraft.log.error("Cannot setup trust manager", (Throwable)e);
            }
            trustManager = tmf;
            return trustManager;
        }
    }

    public static SslContext getSslContext() throws HTTPRequestException {
        if (sslContext != null || triedSslContext) {
            return sslContext;
        }
        Object object = sslLock;
        synchronized (object) {
            if (sslContext != null || triedSslContext) {
                return sslContext;
            }
            try {
                sslContext = SslContextBuilder.forClient().trustManager(NetworkUtils.getTrustManager()).build();
                return sslContext;
            }
            catch (SSLException e) {
                ComputerCraft.log.error("Cannot construct SSL context", (Throwable)e);
                triedSslContext = true;
                sslContext = null;
                throw new HTTPRequestException("Cannot create a secure connection");
            }
        }
    }

    public static InetSocketAddress getAddress(URI uri, boolean ssl) throws HTTPRequestException {
        return NetworkUtils.getAddress(uri.getHost(), uri.getPort(), ssl);
    }

    public static InetSocketAddress getAddress(String host, int port, boolean ssl) throws HTTPRequestException {
        InetSocketAddress socketAddress;
        if (port < 0) {
            int n = port = ssl ? 443 : 80;
        }
        if ((socketAddress = new InetSocketAddress(host, port)).isUnresolved()) {
            throw new HTTPRequestException("Unknown host");
        }
        return socketAddress;
    }

    public static Options getOptions(String host, InetSocketAddress address) throws HTTPRequestException {
        Options options = AddressRule.apply(ComputerCraft.httpRules, host, address);
        if (options.action == Action.DENY) {
            throw new HTTPRequestException("Domain not permitted");
        }
        return options;
    }

    public static byte[] toBytes(ByteBuf buffer) {
        byte[] bytes = new byte[buffer.readableBytes()];
        buffer.readBytes(bytes);
        return bytes;
    }

    static {
        triedSslContext = false;
    }
}

