/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.http;

import dan200.computercraft.core.apis.http.ResourceGroup;
import dan200.computercraft.shared.util.IoUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.io.Closeable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public abstract class Resource<T extends Resource<T>>
implements Closeable {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ResourceGroup<T> limiter;
    private static final ReferenceQueue<Object> QUEUE = new ReferenceQueue();

    protected Resource(ResourceGroup<T> limiter) {
        this.limiter = limiter;
    }

    public final boolean isClosed() {
        return this.closed.get();
    }

    public final boolean checkClosed() {
        if (!this.closed.get()) {
            return false;
        }
        this.dispose();
        return true;
    }

    protected final boolean tryClose() {
        if (this.closed.getAndSet(true)) {
            return false;
        }
        this.dispose();
        return true;
    }

    protected void dispose() {
        Resource thisT = this;
        this.limiter.release(thisT);
    }

    protected <R> WeakReference<R> createOwnerReference(R object) {
        return new CloseReference<R>(this, object);
    }

    @Override
    public final void close() {
        this.tryClose();
    }

    public boolean queue(Consumer<T> task) {
        Resource thisT = this;
        return this.limiter.queue(thisT, () -> task.accept(thisT));
    }

    protected static <T extends Closeable> T closeCloseable(T closeable) {
        IoUtil.closeQuietly(closeable);
        return null;
    }

    protected static ChannelFuture closeChannel(ChannelFuture future) {
        if (future != null) {
            future.cancel(false);
            Channel channel = future.channel();
            if (channel != null && channel.isOpen()) {
                channel.close();
            }
        }
        return null;
    }

    protected static <T extends Future<?>> T closeFuture(T future) {
        if (future != null) {
            future.cancel(true);
        }
        return null;
    }

    public static void cleanup() {
        Reference<Object> reference;
        while ((reference = QUEUE.poll()) != null) {
            ((CloseReference)reference).resource.close();
        }
    }

    private static class CloseReference<T>
    extends WeakReference<T> {
        final Resource<?> resource;

        CloseReference(Resource<?> resource, T referent) {
            super(referent, QUEUE);
            this.resource = resource;
        }
    }
}

