/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.http.websocket;

import com.google.common.base.Strings;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.apis.http.HTTPRequestException;
import dan200.computercraft.core.apis.http.NetworkUtils;
import dan200.computercraft.core.apis.http.Resource;
import dan200.computercraft.core.apis.http.ResourceGroup;
import dan200.computercraft.core.apis.http.options.Options;
import dan200.computercraft.core.apis.http.websocket.WebsocketHandle;
import dan200.computercraft.core.apis.http.websocket.WebsocketHandler;
import dan200.computercraft.shared.util.IoUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.handler.ssl.SslContext;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Future;

public class Websocket
extends Resource<Websocket> {
    public static final int MAX_MESSAGE_SIZE = 0x40000000;
    static final String SUCCESS_EVENT = "websocket_success";
    static final String FAILURE_EVENT = "websocket_failure";
    static final String CLOSE_EVENT = "websocket_closed";
    static final String MESSAGE_EVENT = "websocket_message";
    private Future<?> executorFuture;
    private ChannelFuture connectFuture;
    private WeakReference<WebsocketHandle> websocketHandle;
    private final IAPIEnvironment environment;
    private final URI uri;
    private final String address;
    private final HttpHeaders headers;

    public Websocket(ResourceGroup<Websocket> limiter, IAPIEnvironment environment, URI uri, String address, HttpHeaders headers) {
        super(limiter);
        this.environment = environment;
        this.uri = uri;
        this.address = address;
        this.headers = headers;
    }

    public static URI checkUri(String address) throws HTTPRequestException {
        URI uri = null;
        try {
            uri = new URI(address);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (uri == null || uri.getHost() == null) {
            try {
                uri = new URI("ws://" + address);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (uri == null || uri.getHost() == null) {
            throw new HTTPRequestException("URL malformed");
        }
        String scheme = uri.getScheme();
        if (scheme == null) {
            try {
                uri = new URI("ws://" + uri);
            }
            catch (URISyntaxException e) {
                throw new HTTPRequestException("URL malformed");
            }
        } else if (!scheme.equalsIgnoreCase("wss") && !scheme.equalsIgnoreCase("ws")) {
            throw new HTTPRequestException("Invalid scheme '" + scheme + "'");
        }
        return uri;
    }

    public void connect() {
        if (this.isClosed()) {
            return;
        }
        this.executorFuture = NetworkUtils.EXECUTOR.submit(this::doConnect);
        this.checkClosed();
    }

    private void doConnect() {
        block5: {
            if (this.isClosed()) {
                return;
            }
            try {
                SslContext sslContext;
                boolean ssl = this.uri.getScheme().equalsIgnoreCase("wss");
                final InetSocketAddress socketAddress = NetworkUtils.getAddress(this.uri, ssl);
                final Options options = NetworkUtils.getOptions(this.uri.getHost(), socketAddress);
                Object object = sslContext = ssl ? NetworkUtils.getSslContext() : null;
                if (this.isClosed()) {
                    return;
                }
                this.connectFuture = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(NetworkUtils.LOOP_GROUP)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                    protected void initChannel(SocketChannel ch) {
                        ChannelPipeline p = ch.pipeline();
                        if (sslContext != null) {
                            p.addLast(new ChannelHandler[]{sslContext.newHandler(ch.alloc(), Websocket.this.uri.getHost(), socketAddress.getPort())});
                        }
                        WebSocketClientHandshaker handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)Websocket.this.uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)Websocket.this.headers, (int)(options.websocketMessage <= 0 ? 0x40000000 : options.websocketMessage));
                        p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), WebSocketClientCompressionHandler.INSTANCE, new WebsocketHandler(Websocket.this, handshaker, options)});
                    }
                })).remoteAddress((SocketAddress)socketAddress).connect().addListener(c -> {
                    if (!c.isSuccess()) {
                        this.failure(c.cause().getMessage());
                    }
                });
                this.checkClosed();
            }
            catch (HTTPRequestException e) {
                this.failure(e.getMessage());
            }
            catch (Exception e) {
                this.failure("Could not connect");
                if (!ComputerCraft.logComputerErrors) break block5;
                ComputerCraft.log.error("Error in websocket", (Throwable)e);
            }
        }
    }

    void success(Channel channel, Options options) {
        if (this.isClosed()) {
            return;
        }
        WebsocketHandle handle = new WebsocketHandle(this, options, channel);
        this.environment().queueEvent(SUCCESS_EVENT, this.address, handle);
        this.websocketHandle = this.createOwnerReference(handle);
        this.checkClosed();
    }

    void failure(String message) {
        if (this.tryClose()) {
            this.environment.queueEvent(FAILURE_EVENT, this.address, message);
        }
    }

    void close(int status, String reason) {
        if (this.tryClose()) {
            this.environment.queueEvent(CLOSE_EVENT, this.address, Strings.isNullOrEmpty((String)reason) ? null : reason, status < 0 ? null : Integer.valueOf(status));
        }
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.executorFuture = Websocket.closeFuture(this.executorFuture);
        this.connectFuture = Websocket.closeChannel(this.connectFuture);
        WeakReference<WebsocketHandle> websocketHandleRef = this.websocketHandle;
        WebsocketHandle websocketHandle = websocketHandleRef == null ? null : (WebsocketHandle)websocketHandleRef.get();
        IoUtil.closeQuietly(websocketHandle);
        this.websocketHandle = null;
    }

    public IAPIEnvironment environment() {
        return this.environment;
    }

    public String address() {
        return this.address;
    }
}

