/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.asm;

import dan200.computercraft.api.lua.ILuaCallback;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.ILuaTask;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import java.util.Arrays;
import javax.annotation.Nonnull;

public final class TaskCallback
implements ILuaCallback {
    private final MethodResult pull = MethodResult.pullEvent("task_complete", this);
    private final long task;

    private TaskCallback(long task) {
        this.task = task;
    }

    @Override
    @Nonnull
    public MethodResult resume(Object[] response) throws LuaException {
        if (response.length < 3 || !(response[1] instanceof Number) || !(response[2] instanceof Boolean)) {
            return this.pull;
        }
        if (((Number)response[1]).longValue() != this.task) {
            return this.pull;
        }
        if (((Boolean)response[2]).booleanValue()) {
            return MethodResult.of(Arrays.copyOfRange(response, 3, response.length));
        }
        if (response.length >= 4 && response[3] instanceof String) {
            throw new LuaException((String)response[3]);
        }
        throw new LuaException("error");
    }

    static Object[] checkUnwrap(MethodResult result) {
        if (result.getCallback() != null) {
            throw new IllegalStateException("Cannot return MethodResult for mainThread task.");
        }
        return result.getResult();
    }

    public static MethodResult make(ILuaContext context, ILuaTask func) throws LuaException {
        long task = context.issueMainThreadTask(func);
        return new TaskCallback((long)task).pull;
    }
}

