/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.shared.computer.apis.CommandAPI;
import dan200.computercraft.shared.computer.blocks.TileComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.server.ServerWorld;

public class TileCommandComputer
extends TileComputer {
    private final CommandReceiver receiver = new CommandReceiver();

    public TileCommandComputer(ComputerFamily family, TileEntityType<? extends TileCommandComputer> type) {
        super(family, type);
    }

    public CommandReceiver getReceiver() {
        return this.receiver;
    }

    public CommandSource getSource() {
        String label;
        ServerComputer computer = this.getServerComputer();
        String name = "@";
        if (computer != null && (label = computer.getLabel()) != null) {
            name = label;
        }
        return new CommandSource((ICommandSource)this.receiver, new Vector3d((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5), Vector2f.field_189974_a, (ServerWorld)this.func_145831_w(), 2, name, (ITextComponent)new StringTextComponent(name), this.func_145831_w().func_73046_m(), null);
    }

    @Override
    protected ServerComputer createComputer(int instanceID, int id) {
        ServerComputer computer = super.createComputer(instanceID, id);
        computer.addAPI(new CommandAPI(this));
        return computer;
    }

    @Override
    public boolean isUsable(PlayerEntity player, boolean ignoreRange) {
        return TileCommandComputer.isUsable(player) && super.isUsable(player, ignoreRange);
    }

    public static boolean isUsable(PlayerEntity player) {
        MinecraftServer server = player.func_184102_h();
        if (server == null || !server.func_82356_Z()) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("advMode.notEnabled"), true);
            return false;
        }
        if (ComputerCraft.commandRequireCreative ? !player.func_195070_dx() : !server.func_184103_al().func_152596_g(player.func_146103_bH())) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("advMode.notAllowed"), true);
            return false;
        }
        return true;
    }

    public class CommandReceiver
    implements ICommandSource {
        private final Map<Integer, String> output = new HashMap<Integer, String>();

        public void clearOutput() {
            this.output.clear();
        }

        public Map<Integer, String> getOutput() {
            return this.output;
        }

        public Map<Integer, String> copyOutput() {
            return new HashMap<Integer, String>(this.output);
        }

        public void func_145747_a(@Nonnull ITextComponent textComponent, @Nonnull UUID id) {
            this.output.put(this.output.size() + 1, textComponent.getString());
        }

        public boolean func_195039_a() {
            return TileCommandComputer.this.func_145831_w().func_82736_K().func_223586_b(GameRules.field_223611_n);
        }

        public boolean func_195040_b() {
            return true;
        }

        public boolean func_195041_r_() {
            return TileCommandComputer.this.func_145831_w().func_82736_K().func_223586_b(GameRules.field_223605_h);
        }
    }
}

