/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.inventory;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.computer.core.IContainerComputer;
import dan200.computercraft.shared.computer.core.InputState;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;

public class ContainerComputerBase
extends Container
implements IContainerComputer {
    private final Predicate<PlayerEntity> canUse;
    private final IComputer computer;
    private final ComputerFamily family;
    private final InputState input = new InputState(this);

    protected ContainerComputerBase(ContainerType<? extends ContainerComputerBase> type, int id, Predicate<PlayerEntity> canUse, IComputer computer, ComputerFamily family) {
        super(type, id);
        this.canUse = canUse;
        this.computer = computer;
        this.family = family;
    }

    protected ContainerComputerBase(ContainerType<? extends ContainerComputerBase> type, int id, PlayerInventory player, ComputerContainerData data) {
        this(type, id, x -> true, ContainerComputerBase.getComputer(player, data), data.getFamily());
    }

    protected static IComputer getComputer(PlayerInventory player, ComputerContainerData data) {
        int id = data.getInstanceId();
        if (!player.field_70458_d.field_70170_p.field_72995_K) {
            return ComputerCraft.serverComputerRegistry.get(id);
        }
        ClientComputer computer = (ClientComputer)ComputerCraft.clientComputerRegistry.get(id);
        if (computer == null) {
            computer = new ClientComputer(id);
            ComputerCraft.clientComputerRegistry.add(id, computer);
        }
        return computer;
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return this.canUse.test(player);
    }

    @Nonnull
    public ComputerFamily getFamily() {
        return this.family;
    }

    @Override
    @Nullable
    public IComputer getComputer() {
        return this.computer;
    }

    @Override
    @Nonnull
    public InputState getInput() {
        return this.input;
    }

    public void func_75134_a(@Nonnull PlayerEntity player) {
        super.func_75134_a(player);
        this.input.close();
    }
}

